/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.view.RestfulViewProperties;
import org.apereo.cas.services.web.CasThymeleafLoginFormDirector;
import org.apereo.cas.services.web.CasThymeleafOutputTemplateHandler;
import org.apereo.cas.services.web.CasThymeleafViewResolverConfigurer;
import org.apereo.cas.services.web.ThemeBasedViewResolver;
import org.apereo.cas.services.web.ThemeViewResolver;
import org.apereo.cas.services.web.ThemeViewResolverFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.CasProtocolViewFactory;
import org.apereo.cas.web.view.CasProtocolThymeleafViewFactory;
import org.apereo.cas.web.view.ChainingTemplateViewResolver;
import org.apereo.cas.web.view.RestfulUrlTemplateResolver;
import org.apereo.cas.web.view.ThemeClassLoaderTemplateResolver;
import org.apereo.cas.web.view.ThemeFileTemplateResolver;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafAutoConfiguration;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;
import org.springframework.util.MimeType;
import org.springframework.util.ResourceUtils;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.ViewResolver;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.dialect.IPostProcessorDialect;
import org.thymeleaf.postprocessor.IPostProcessor;
import org.thymeleaf.postprocessor.PostProcessor;
import org.thymeleaf.spring5.ISpringTemplateEngine;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.AbstractTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;

@Configuration(value="casThymeleafConfiguration", proxyBeanMethods=true)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnClass(value={SpringTemplateEngine.class})
@ImportAutoConfiguration(value={ThymeleafAutoConfiguration.class})
public class CasThymeleafConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="themeResolver")
    private ObjectProvider<ThemeResolver> themeResolver;
    @Autowired
    private ObjectProvider<List<CasThymeleafViewResolverConfigurer>> thymeleafViewResolverConfigurers;
    @Autowired
    private ObjectProvider<SpringTemplateEngine> springTemplateEngine;
    @Autowired
    private ObjectProvider<ThymeleafProperties> thymeleafProperties;

    private static String appendCharset(MimeType type, String charset) {
        if (type.getCharset() != null) {
            return type.toString();
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("charset", charset);
        parameters.putAll(type.getParameters());
        return new MimeType(type, parameters).toString();
    }

    @Bean
    public AbstractTemplateResolver chainingTemplateViewResolver() {
        ChainingTemplateViewResolver chain = new ChainingTemplateViewResolver();
        ClassLoaderTemplateResolver cpResolver = new ClassLoaderTemplateResolver();
        this.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)cpResolver);
        cpResolver.setPrefix("thymeleaf/templates/");
        chain.addResolver((AbstractTemplateResolver)cpResolver);
        ThemeClassLoaderTemplateResolver themeCp = new ThemeClassLoaderTemplateResolver(this.casProperties);
        this.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)themeCp);
        themeCp.setPrefix("templates/%s/");
        chain.addResolver((AbstractTemplateResolver)themeCp);
        List templatePrefixes = this.casProperties.getView().getTemplatePrefixes();
        templatePrefixes.forEach(Unchecked.consumer(prefix -> {
            String prefixPath = ResourceUtils.getFile((String)prefix).getCanonicalPath();
            String viewPath = StringUtils.appendIfMissing((String)prefixPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            RestfulViewProperties rest = this.casProperties.getView().getRest();
            if (StringUtils.isNotBlank((CharSequence)rest.getUrl())) {
                RestfulUrlTemplateResolver url = new RestfulUrlTemplateResolver(this.casProperties);
                this.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)url);
                chain.addResolver((AbstractTemplateResolver)url);
            }
            ThemeFileTemplateResolver theme = new ThemeFileTemplateResolver(this.casProperties);
            this.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)theme);
            theme.setPrefix(viewPath + "themes/%s/");
            chain.addResolver((AbstractTemplateResolver)theme);
            FileTemplateResolver file = new FileTemplateResolver();
            this.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)file);
            file.setPrefix(viewPath);
            chain.addResolver((AbstractTemplateResolver)file);
        }));
        chain.initialize();
        return chain;
    }

    @ConditionalOnMissingBean(name={"casPropertiesThymeleafViewResolverConfigurer"})
    @Bean
    @RefreshScope
    public CasThymeleafViewResolverConfigurer casPropertiesThymeleafViewResolverConfigurer() {
        return new CasThymeleafViewResolverConfigurer(){

            @Override
            public int getOrder() {
                return 0;
            }

            @Override
            public void configureThymeleafViewResolver(ThymeleafViewResolver thymeleafViewResolver) {
                thymeleafViewResolver.addStaticVariable("cas", (Object)CasThymeleafConfiguration.this.casProperties);
                thymeleafViewResolver.addStaticVariable("casProperties", (Object)CasThymeleafConfiguration.this.casProperties);
            }
        };
    }

    @ConditionalOnMissingBean(name={"registeredServiceViewResolver"})
    @Bean
    @Autowired
    @RefreshScope
    public ViewResolver registeredServiceViewResolver(@Qualifier(value="themeViewResolverFactory") ThemeViewResolverFactory themeViewResolverFactory) {
        ThemeBasedViewResolver resolver = new ThemeBasedViewResolver((ThemeResolver)this.themeResolver.getObject(), themeViewResolverFactory);
        resolver.setOrder(this.thymeleafViewResolver().getOrder() - 1);
        return resolver;
    }

    @ConditionalOnMissingBean(name={"casThymeleafLoginFormDirector"})
    @Bean
    @RefreshScope
    public CasThymeleafLoginFormDirector casThymeleafLoginFormDirector() {
        return new CasThymeleafLoginFormDirector();
    }

    @ConditionalOnMissingBean(name={"themeViewResolverFactory"})
    @Bean
    @RefreshScope
    public ThemeViewResolverFactory themeViewResolverFactory() {
        ThemeViewResolver.Factory factory = new ThemeViewResolver.Factory((ViewResolver)this.thymeleafViewResolver(), (ThymeleafProperties)this.thymeleafProperties.getObject(), this.casProperties);
        factory.setApplicationContext((ApplicationContext)this.applicationContext);
        return factory;
    }

    @ConditionalOnMissingBean(name={"casProtocolViewFactory"})
    @Bean
    @RefreshScope
    public CasProtocolViewFactory casProtocolViewFactory() {
        return new CasProtocolThymeleafViewFactory((SpringTemplateEngine)this.springTemplateEngine.getObject(), (ThymeleafProperties)this.thymeleafProperties.getObject());
    }

    @Bean
    public ThymeleafViewResolver thymeleafViewResolver() {
        ThymeleafViewResolver resolver = new ThymeleafViewResolver();
        ThymeleafProperties properties = (ThymeleafProperties)this.thymeleafProperties.getObject();
        resolver.setProducePartialOutputWhileProcessing(properties.getServlet().isProducePartialOutputWhileProcessing());
        resolver.setCharacterEncoding(properties.getEncoding().name());
        resolver.setApplicationContext((ApplicationContext)this.applicationContext);
        resolver.setExcludedViewNames(properties.getExcludedViewNames());
        resolver.setOrder(0x7FFFFFFA);
        resolver.setCache(false);
        resolver.setViewNames(properties.getViewNames());
        resolver.setContentType(CasThymeleafConfiguration.appendCharset(properties.getServlet().getContentType(), resolver.getCharacterEncoding()));
        SpringTemplateEngine engine = (SpringTemplateEngine)this.springTemplateEngine.getObject();
        if (!engine.isInitialized()) {
            engine.addDialect((IDialect)new IPostProcessorDialect(){

                public int getDialectPostProcessorPrecedence() {
                    return Integer.MAX_VALUE;
                }

                public Set<IPostProcessor> getPostProcessors() {
                    return CollectionUtils.wrapSet((Object)new PostProcessor(TemplateMode.parse((String)((ThymeleafProperties)CasThymeleafConfiguration.this.thymeleafProperties.getObject()).getMode()), CasThymeleafOutputTemplateHandler.class, Integer.MAX_VALUE));
                }

                public String getName() {
                    return CasThymeleafOutputTemplateHandler.class.getSimpleName();
                }
            });
        }
        resolver.setTemplateEngine((ISpringTemplateEngine)engine);
        ((List)this.thymeleafViewResolverConfigurers.getObject()).stream().sorted(OrderComparator.INSTANCE).forEach(configurer -> configurer.configureThymeleafViewResolver(resolver));
        return resolver;
    }

    private void configureTemplateViewResolver(AbstractConfigurableTemplateResolver resolver) {
        ThymeleafProperties props = (ThymeleafProperties)this.thymeleafProperties.getObject();
        resolver.setCacheable(props.isCache());
        resolver.setCharacterEncoding(props.getEncoding().name());
        resolver.setCheckExistence(props.isCheckTemplateLocation());
        resolver.setForceTemplateMode(true);
        resolver.setOrder(Integer.valueOf(0));
        resolver.setSuffix(".html");
        resolver.setTemplateMode(props.getMode());
    }
}

