/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.thymeleaf.context.WebEngineContext;

public class CasThymeleafLoginFormDirector {
    public boolean isLoginFormViewable(WebEngineContext vars) {
        RequestContext context = RequestContextHolder.getRequestContext();
        return context != null && WebUtils.getDelegatedAuthenticationProviderPrimary((RequestContext)context) == null && WebUtils.isCasLoginFormViewable((RequestContext)context);
    }

    public boolean isLoginFormUsernameInputVisible(WebEngineContext vars) {
        RequestContext context = RequestContextHolder.getRequestContext();
        return context != null && WebUtils.isCasLoginFormViewable((RequestContext)context) && StringUtils.isBlank((CharSequence)WebUtils.getOpenIdLocalUserId((RequestContext)context)) && WebUtils.getPasswordlessAuthenticationAccount((RequestContext)context, Serializable.class) == null;
    }

    public boolean isLoginFormUsernameInputDisabled(WebEngineContext vars) {
        RequestContext context = RequestContextHolder.getRequestContext();
        return context == null || !WebUtils.isCasLoginFormViewable((RequestContext)context) || WebUtils.isGraphicalUserAuthenticationEnabled((RequestContext)context) || WebUtils.getPasswordlessAuthenticationAccount((RequestContext)context, Serializable.class) != null;
    }

    public String getLoginFormUsername(WebEngineContext vars) {
        BasicIdentifiableCredential acct;
        String user;
        RequestContext context = RequestContextHolder.getRequestContext();
        if (context != null && WebUtils.isCasLoginFormViewable((RequestContext)context) && StringUtils.isBlank((CharSequence)(user = WebUtils.getOpenIdLocalUserId((RequestContext)context))) && (acct = (BasicIdentifiableCredential)WebUtils.getPasswordlessAuthenticationAccount((RequestContext)context, BasicIdentifiableCredential.class)) != null) {
            return acct.getId();
        }
        return "";
    }
}

