/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresource.ClassLoaderTemplateResource;
import org.thymeleaf.templateresource.ITemplateResource;

public class ThemeClassLoaderTemplateResolver
extends ClassLoaderTemplateResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeClassLoaderTemplateResolver.class);
    private final CasConfigurationProperties casProperties;

    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        String themeTemplate;
        ClassLoaderTemplateResource resource;
        String themeName = this.getCurrentTheme();
        if (StringUtils.isNotBlank((CharSequence)themeName) && (resource = new ClassLoaderTemplateResource(themeTemplate = String.format(resourceName, themeName), StandardCharsets.UTF_8.name())).exists()) {
            LOGGER.trace("Computing template resource [{}]...", (Object)themeTemplate);
            return super.computeTemplateResource(configuration, ownerTemplate, template, themeTemplate, characterEncoding, templateResolutionAttributes);
        }
        return super.computeTemplateResource(configuration, ownerTemplate, template, resourceName, characterEncoding, templateResolutionAttributes);
    }

    protected String getCurrentTheme() {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext();
        if (request != null) {
            HttpSession session = request.getSession(false);
            String paramName = this.casProperties.getTheme().getParamName();
            if (session != null) {
                return (String)session.getAttribute(paramName);
            }
            return (String)request.getAttribute(paramName);
        }
        return null;
    }

    @Generated
    public ThemeClassLoaderTemplateResolver(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

