/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.view.ViewProperties;
import org.apereo.cas.services.web.CasThymeleafLoginFormDirector;
import org.apereo.cas.services.web.CasThymeleafOutputTemplateHandler;
import org.apereo.cas.services.web.CasThymeleafViewResolverConfigurer;
import org.apereo.cas.services.web.ThemeBasedViewResolver;
import org.apereo.cas.services.web.ThemeViewResolver;
import org.apereo.cas.services.web.ThemeViewResolverFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.CasProtocolViewFactory;
import org.apereo.cas.web.view.CasProtocolThymeleafViewFactory;
import org.apereo.cas.web.view.ChainingTemplateViewResolver;
import org.apereo.cas.web.view.RestfulUrlTemplateResolver;
import org.apereo.cas.web.view.ThemeFileTemplateResolver;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafAutoConfiguration;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;
import org.springframework.util.ResourceUtils;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.ViewResolver;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.dialect.IPostProcessorDialect;
import org.thymeleaf.postprocessor.IPostProcessor;
import org.thymeleaf.postprocessor.PostProcessor;
import org.thymeleaf.spring5.ISpringTemplateEngine;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.AbstractTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;

@Configuration(value="casThymeleafConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnClass(value={SpringTemplateEngine.class})
@ImportAutoConfiguration(value={ThymeleafAutoConfiguration.class})
public class CasThymeleafConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="themeResolver")
    private ObjectProvider<ThemeResolver> themeResolver;
    @Autowired
    @Qualifier(value="thymeleafViewResolver")
    private ObjectProvider<ThymeleafViewResolver> thymeleafViewResolver;
    @Autowired
    private ObjectProvider<List<CasThymeleafViewResolverConfigurer>> thymeleafViewResolverConfigurers;
    @Autowired
    private ObjectProvider<SpringTemplateEngine> springTemplateEngine;
    @Autowired
    private ObjectProvider<ThymeleafProperties> thymeleafProperties;

    @Bean
    @RefreshScope
    public AbstractTemplateResolver chainingTemplateViewResolver() {
        ChainingTemplateViewResolver chain = new ChainingTemplateViewResolver();
        List templatePrefixes = this.casProperties.getView().getTemplatePrefixes();
        templatePrefixes.forEach(Unchecked.consumer(prefix -> {
            String prefixPath = ResourceUtils.getFile((String)prefix).getCanonicalPath();
            String viewPath = StringUtils.appendIfMissing((String)prefixPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            ViewProperties.Rest rest = this.casProperties.getView().getRest();
            if (StringUtils.isNotBlank((CharSequence)rest.getUrl())) {
                RestfulUrlTemplateResolver url = new RestfulUrlTemplateResolver(this.casProperties);
                this.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)url);
                chain.addResolver((AbstractTemplateResolver)url);
            }
            ThemeFileTemplateResolver theme = new ThemeFileTemplateResolver(this.casProperties);
            this.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)theme);
            theme.setPrefix(viewPath + "themes/%s/");
            chain.addResolver((AbstractTemplateResolver)theme);
            FileTemplateResolver file = new FileTemplateResolver();
            this.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)file);
            file.setPrefix(viewPath);
            chain.addResolver((AbstractTemplateResolver)file);
        }));
        chain.initialize();
        return chain;
    }

    @ConditionalOnMissingBean(name={"casPropertiesThymeleafViewResolverConfigurer"})
    @Bean
    @RefreshScope
    public CasThymeleafViewResolverConfigurer casPropertiesThymeleafViewResolverConfigurer() {
        return new CasThymeleafViewResolverConfigurer(){

            @Override
            public int getOrder() {
                return 0;
            }

            @Override
            public void configureThymeleafViewResolver(ThymeleafViewResolver thymeleafViewResolver) {
                thymeleafViewResolver.addStaticVariable("cas", (Object)CasThymeleafConfiguration.this.casProperties);
                thymeleafViewResolver.addStaticVariable("casProperties", (Object)CasThymeleafConfiguration.this.casProperties);
            }
        };
    }

    @ConditionalOnMissingBean(name={"registeredServiceViewResolver"})
    @Bean
    @Autowired
    @RefreshScope
    public ViewResolver registeredServiceViewResolver(@Qualifier(value="themeViewResolverFactory") ThemeViewResolverFactory themeViewResolverFactory) {
        ThemeBasedViewResolver resolver = new ThemeBasedViewResolver((ThemeResolver)this.themeResolver.getObject(), themeViewResolverFactory);
        resolver.setOrder(((ThymeleafViewResolver)this.thymeleafViewResolver.getObject()).getOrder() - 1);
        return resolver;
    }

    @ConditionalOnMissingBean(name={"casThymeleafLoginFormDirector"})
    @Bean
    @RefreshScope
    public CasThymeleafLoginFormDirector casThymeleafLoginFormDirector() {
        return new CasThymeleafLoginFormDirector();
    }

    @ConditionalOnMissingBean(name={"themeViewResolverFactory"})
    @Bean
    @RefreshScope
    public ThemeViewResolverFactory themeViewResolverFactory() {
        ThemeViewResolver.Factory factory = new ThemeViewResolver.Factory((ViewResolver)this.nonCachingThymeleafViewResolver(), (ThymeleafProperties)this.thymeleafProperties.getObject());
        factory.setApplicationContext((ApplicationContext)this.applicationContext);
        return factory;
    }

    @ConditionalOnMissingBean(name={"casProtocolViewFactory"})
    @Bean
    @RefreshScope
    public CasProtocolViewFactory casProtocolViewFactory() {
        return new CasProtocolThymeleafViewFactory((SpringTemplateEngine)this.springTemplateEngine.getObject(), (ThymeleafProperties)this.thymeleafProperties.getObject());
    }

    private ThymeleafViewResolver nonCachingThymeleafViewResolver() {
        ThymeleafViewResolver r = new ThymeleafViewResolver();
        ThymeleafViewResolver thymeleafResolver = (ThymeleafViewResolver)this.thymeleafViewResolver.getObject();
        r.setAlwaysProcessRedirectAndForward(thymeleafResolver.getAlwaysProcessRedirectAndForward());
        r.setApplicationContext(thymeleafResolver.getApplicationContext());
        r.setCacheUnresolved(thymeleafResolver.isCacheUnresolved());
        r.setCharacterEncoding(thymeleafResolver.getCharacterEncoding());
        r.setContentType(thymeleafResolver.getContentType());
        r.setExcludedViewNames(thymeleafResolver.getExcludedViewNames());
        r.setOrder(thymeleafResolver.getOrder());
        r.setRedirectContextRelative(thymeleafResolver.isRedirectContextRelative());
        r.setRedirectHttp10Compatible(thymeleafResolver.isRedirectHttp10Compatible());
        r.setStaticVariables(thymeleafResolver.getStaticVariables());
        r.setForceContentType(thymeleafResolver.getForceContentType());
        SpringTemplateEngine engine = (SpringTemplateEngine)SpringTemplateEngine.class.cast(thymeleafResolver.getTemplateEngine());
        if (!engine.isInitialized()) {
            engine.addDialect((IDialect)new IPostProcessorDialect(){

                public int getDialectPostProcessorPrecedence() {
                    return Integer.MAX_VALUE;
                }

                public Set<IPostProcessor> getPostProcessors() {
                    return CollectionUtils.wrapSet((Object)new PostProcessor(TemplateMode.parse((String)((ThymeleafProperties)CasThymeleafConfiguration.this.thymeleafProperties.getObject()).getMode()), CasThymeleafOutputTemplateHandler.class, Integer.MAX_VALUE));
                }

                public String getName() {
                    return CasThymeleafOutputTemplateHandler.class.getSimpleName();
                }
            });
        }
        r.setTemplateEngine((ISpringTemplateEngine)engine);
        r.setViewNames(thymeleafResolver.getViewNames());
        r.setCache(false);
        ((List)this.thymeleafViewResolverConfigurers.getObject()).stream().sorted(OrderComparator.INSTANCE).forEach(configurer -> configurer.configureThymeleafViewResolver(r));
        return r;
    }

    private void configureTemplateViewResolver(AbstractConfigurableTemplateResolver resolver) {
        ThymeleafProperties props = (ThymeleafProperties)this.thymeleafProperties.getObject();
        resolver.setCacheable(props.isCache());
        resolver.setCharacterEncoding(props.getEncoding().name());
        resolver.setCheckExistence(props.isCheckTemplateLocation());
        resolver.setForceTemplateMode(true);
        resolver.setOrder(Integer.valueOf(0));
        resolver.setSuffix(".html");
        resolver.setTemplateMode(props.getMode());
    }
}

