/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCommunicationStrategy;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicketExpirationPolicyBuilder;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicketFactory;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationUniqueTicketIdGenerator;
import org.apereo.cas.mfa.simple.ticket.DefaultCasSimpleMultifactorAuthenticationTicketFactory;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorSendTokenAction;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorTrustedDeviceWebflowConfigurer;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorWebflowConfigurer;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketFactoryExecutionPlanConfigurer;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.trusted.config.ConditionalOnMultifactorTrustedDevicesEnabled;
import org.apereo.cas.trusted.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="casSimpleMultifactorAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
public class CasSimpleMultifactorAuthenticationConfiguration {
    private static final int WEBFLOW_CONFIGURER_ORDER = 100;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="communicationsManager")
    private ObjectProvider<CommunicationsManager> communicationsManager;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="flowBuilder")
    private ObjectProvider<FlowBuilder> flowBuilder;

    @Bean
    @ConditionalOnMissingBean(name={"mfaSimpleAuthenticatorFlowRegistry"})
    public FlowDefinitionRegistry mfaSimpleAuthenticatorFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)this.applicationContext, (FlowBuilderServices)this.flowBuilderServices.getObject());
        builder.addFlowBuilder((FlowBuilder)this.flowBuilder.getObject(), "mfa-simple");
        return builder.build();
    }

    @ConditionalOnMissingBean(name={"mfaSimpleMultifactorWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer mfaSimpleMultifactorWebflowConfigurer() {
        CasSimpleMultifactorWebflowConfigurer cfg = new CasSimpleMultifactorWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.mfaSimpleAuthenticatorFlowRegistry(), this.applicationContext, this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)this.applicationContext));
        cfg.setOrder(100);
        return cfg;
    }

    @Bean
    @ConditionalOnMissingBean(name={"mfaSimpleCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer mfaSimpleCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.mfaSimpleMultifactorWebflowConfigurer());
    }

    @ConditionalOnMissingBean(name={"mfaSimpleMultifactorSendTokenAction"})
    @Bean
    @RefreshScope
    public Action mfaSimpleMultifactorSendTokenAction() {
        CasSimpleMultifactorAuthenticationProperties simple = this.casProperties.getAuthn().getMfa().getSimple();
        return new CasSimpleMultifactorSendTokenAction((TicketRegistry)this.ticketRegistry.getObject(), (CommunicationsManager)this.communicationsManager.getObject(), this.casSimpleMultifactorAuthenticationTicketFactory(), simple, this.mfaSimpleMultifactorTokenCommunicationStrategy());
    }

    @ConditionalOnMissingBean(name={"mfaSimpleMultifactorTokenCommunicationStrategy"})
    @Bean
    public CasSimpleMultifactorTokenCommunicationStrategy mfaSimpleMultifactorTokenCommunicationStrategy() {
        return CasSimpleMultifactorTokenCommunicationStrategy.all();
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationTicketExpirationPolicy"})
    @Bean
    @RefreshScope
    public ExpirationPolicyBuilder casSimpleMultifactorAuthenticationTicketExpirationPolicy() {
        return new CasSimpleMultifactorAuthenticationTicketExpirationPolicyBuilder(this.casProperties);
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationUniqueTicketIdGenerator"})
    @Bean
    @RefreshScope
    public UniqueTicketIdGenerator casSimpleMultifactorAuthenticationUniqueTicketIdGenerator() {
        CasSimpleMultifactorAuthenticationProperties simple = this.casProperties.getAuthn().getMfa().getSimple();
        return new CasSimpleMultifactorAuthenticationUniqueTicketIdGenerator(simple.getTokenLength());
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationTicketFactory"})
    @Bean
    @RefreshScope
    public CasSimpleMultifactorAuthenticationTicketFactory casSimpleMultifactorAuthenticationTicketFactory() {
        return new DefaultCasSimpleMultifactorAuthenticationTicketFactory(this.casSimpleMultifactorAuthenticationTicketExpirationPolicy(), this.casSimpleMultifactorAuthenticationUniqueTicketIdGenerator());
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationTicketFactoryConfigurer"})
    @Bean
    @RefreshScope
    public TicketFactoryExecutionPlanConfigurer casSimpleMultifactorAuthenticationTicketFactoryConfigurer() {
        return this::casSimpleMultifactorAuthenticationTicketFactory;
    }

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @Configuration(value="casSimpleMultifactorTrustConfiguration")
    @ConditionalOnMultifactorTrustedDevicesEnabled(prefix="cas.authn.mfa.simple")
    public class CasSimpleMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorTrustWebflowConfigurer"})
        @Bean
        @DependsOn(value={"defaultWebflowConfigurer"})
        public CasWebflowConfigurer mfaSimpleMultifactorTrustWebflowConfigurer() {
            CasSimpleMultifactorTrustedDeviceWebflowConfigurer cfg = new CasSimpleMultifactorTrustedDeviceWebflowConfigurer((FlowBuilderServices)CasSimpleMultifactorAuthenticationConfiguration.this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)CasSimpleMultifactorAuthenticationConfiguration.this.loginFlowDefinitionRegistry.getObject(), CasSimpleMultifactorAuthenticationConfiguration.this.mfaSimpleAuthenticatorFlowRegistry(), CasSimpleMultifactorAuthenticationConfiguration.this.applicationContext, CasSimpleMultifactorAuthenticationConfiguration.this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)CasSimpleMultifactorAuthenticationConfiguration.this.applicationContext));
            cfg.setOrder(101);
            return cfg;
        }

        @ConditionalOnMissingBean(name={"casSimpleMultifactorTrustWebflowExecutionPlanConfigurer"})
        @Bean
        public CasWebflowExecutionPlanConfigurer casSimpleMultifactorTrustWebflowExecutionPlanConfigurer() {
            return plan -> plan.registerWebflowConfigurer(this.mfaSimpleMultifactorTrustWebflowConfigurer());
        }
    }
}

