/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.saml.SamlCoreProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.services.CasProtocolVersions;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.authentication.SamlResponseBuilder;
import org.apereo.cas.support.saml.authentication.principal.SamlServiceResponseBuilder;
import org.apereo.cas.support.saml.util.Saml10ObjectBuilder;
import org.apereo.cas.support.saml.web.SamlValidateController;
import org.apereo.cas.support.saml.web.SamlValidateEndpoint;
import org.apereo.cas.support.saml.web.view.Saml10FailureResponseView;
import org.apereo.cas.support.saml.web.view.Saml10SuccessResponseView;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.CasProtocolVersionValidationSpecification;
import org.apereo.cas.validation.ChainingCasProtocolValidationSpecification;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.apereo.cas.web.ServiceValidateConfigurationContext;
import org.apereo.cas.web.ServiceValidationViewFactoryConfigurer;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.view.attributes.NoOpProtocolAttributesRenderer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.View;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SAML})
@Configuration(value="SamlConfiguration", proxyBeanMethods=false)
class SamlConfiguration {
    SamlConfiguration() {
    }

    @Configuration(value="SamlWebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlWebConfiguration {
        SamlWebConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlValidateEndpoint samlValidateEndpoint(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="samlResponseBuilder") ObjectProvider<SamlResponseBuilder> samlResponseBuilder, @Qualifier(value="webApplicationServiceFactory") ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory, @Qualifier(value="shibboleth.OpenSAMLConfig") ObjectProvider<OpenSamlConfigBean> openSamlConfigBean, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager, @Qualifier(value="defaultAuthenticationSystemSupport") ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport, @Qualifier(value="registeredServiceAccessStrategyEnforcer") ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer, @Qualifier(value="defaultPrincipalResolver") ObjectProvider<PrincipalResolver> defaultPrincipalResolver, @Qualifier(value="principalFactory") ObjectProvider<PrincipalFactory> principalFactory) {
            return new SamlValidateEndpoint(casProperties, applicationContext, servicesManager, authenticationSystemSupport, webApplicationServiceFactory, principalFactory, samlResponseBuilder, openSamlConfigBean, registeredServiceAccessStrategyEnforcer, defaultPrincipalResolver);
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlValidateControllerValidationSpecification"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasProtocolValidationSpecification samlValidateControllerValidationSpecification(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="casSingleAuthenticationProtocolValidationSpecification") CasProtocolValidationSpecification casSingleAuthenticationProtocolValidationSpecification) {
            ChainingCasProtocolValidationSpecification validationChain = new ChainingCasProtocolValidationSpecification();
            validationChain.addSpecification(casSingleAuthenticationProtocolValidationSpecification);
            validationChain.addSpecification((CasProtocolValidationSpecification)new CasProtocolVersionValidationSpecification(Set.of(CasProtocolVersions.SAML1), tenantExtractor));
            return validationChain;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlValidateController samlValidateController(@Qualifier(value="casValidationConfigurationContext") ServiceValidateConfigurationContext casValidationConfigurationContext, @Qualifier(value="proxy20Handler") ProxyHandler proxy20Handler, @Qualifier(value="samlValidateControllerValidationSpecification") CasProtocolValidationSpecification samlValidateControllerValidationSpecification) {
            return new SamlValidateController(casValidationConfigurationContext.withValidationSpecifications(CollectionUtils.wrapSet((Object)samlValidateControllerValidationSpecification)).withProxyHandler(proxy20Handler));
        }
    }

    @Configuration(value="SamlWebSecurityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlWebSecurityConfiguration {
        SamlWebSecurityConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebSecurityConfigurer<Void> samlProtocolEndpointConfigurer() {
            return new CasWebSecurityConfigurer<Void>(this){

                public List<String> getIgnoredEndpoints() {
                    return List.of(Strings.CI.prependIfMissing("/samlValidate", (CharSequence)"/", new CharSequence[0]));
                }
            };
        }
    }

    @Configuration(value="SamlViewsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlViewsConfiguration {
        SamlViewsConfiguration() {
        }

        @ConditionalOnMissingBean(name={"casSamlServiceSuccessView"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public View casSamlServiceSuccessView(@Qualifier(value="samlResponseBuilder") SamlResponseBuilder samlResponseBuilder, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="casAttributeEncoder") ProtocolAttributeEncoder protocolAttributeEncoder, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore) {
            return new Saml10SuccessResponseView(protocolAttributeEncoder, servicesManager, argumentExtractor, authenticationAttributeReleasePolicy, authenticationServiceSelectionPlan, NoOpProtocolAttributesRenderer.INSTANCE, samlResponseBuilder, attributeDefinitionStore);
        }

        @ConditionalOnMissingBean(name={"casSamlServiceFailureView"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public View casSamlServiceFailureView(@Qualifier(value="samlResponseBuilder") SamlResponseBuilder samlResponseBuilder, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="casAttributeEncoder") ProtocolAttributeEncoder protocolAttributeEncoder, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore) {
            return new Saml10FailureResponseView(protocolAttributeEncoder, servicesManager, argumentExtractor, authenticationAttributeReleasePolicy, authenticationServiceSelectionPlan, NoOpProtocolAttributesRenderer.INSTANCE, samlResponseBuilder, attributeDefinitionStore);
        }
    }

    @Configuration(value="SamlBuilderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlBuilderConfiguration {
        SamlBuilderConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlResponseBuilder"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public SamlResponseBuilder samlResponseBuilder(@Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="saml10ObjectBuilder") Saml10ObjectBuilder saml10ObjectBuilder, @Qualifier(value="casAttributeEncoder") ProtocolAttributeEncoder protocolAttributeEncoder) {
            SamlCoreProperties samlCore = casProperties.getSamlCore();
            return new SamlResponseBuilder(saml10ObjectBuilder, samlCore.getIssuer(), samlCore.getAttributeNamespace(), samlCore.getIssueLength(), samlCore.getSkewAllowance(), protocolAttributeEncoder, servicesManager);
        }

        @ConditionalOnMissingBean(name={"samlServiceResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ResponseBuilder samlServiceResponseBuilder(@Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="urlValidator") UrlValidator urlValidator) {
            return new SamlServiceResponseBuilder(servicesManager, urlValidator);
        }

        @ConditionalOnMissingBean(name={"saml10ObjectBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Saml10ObjectBuilder saml10ObjectBuilder(@Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean openSamlConfigBean) {
            return new Saml10ObjectBuilder(openSamlConfigBean);
        }
    }

    @Configuration(value="SamlViewFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlViewFactoryConfiguration {
        SamlViewFactoryConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"samlServiceValidationViewFactoryConfigurer"})
        public ServiceValidationViewFactoryConfigurer samlServiceValidationViewFactoryConfigurer(@Qualifier(value="casSamlServiceSuccessView") View casSamlServiceSuccessView, @Qualifier(value="casSamlServiceFailureView") View casSamlServiceFailureView) {
            return factory -> factory.registerView(SamlValidateController.class, Pair.of((Object)casSamlServiceSuccessView, (Object)casSamlServiceFailureView));
        }
    }
}

