/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.support.saml.authentication.principal.SamlService;
import org.apereo.cas.support.saml.authentication.principal.SamlServiceFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.UrlValidator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SAML})
@Configuration(value="SamlServiceFactoryConfiguration", proxyBeanMethods=false)
class SamlServiceFactoryConfiguration {
    SamlServiceFactoryConfiguration() {
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public ServiceFactoryConfigurer samlServiceFactoryConfigurer(@Qualifier(value="samlServiceFactory") ServiceFactory<SamlService> samlServiceFactory) {
        return () -> CollectionUtils.wrap((Object)samlServiceFactory);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public ServiceFactory<SamlService> samlServiceFactory(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="urlValidator") UrlValidator urlValidator) {
        return new SamlServiceFactory(tenantExtractor, urlValidator);
    }
}

