/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.authentication;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.util.Saml10ObjectBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.StatusCode;
import org.opensaml.saml.saml1.core.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlResponseBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlResponseBuilder.class);
    private final Saml10ObjectBuilder samlObjectBuilder;
    private final String issuer;
    private final String defaultAttributeNamespace;
    private final int issueLength;
    private final int skewAllowance;
    private final ProtocolAttributeEncoder protocolAttributeEncoder;
    private final ServicesManager servicesManager;

    public Response createResponse(String serviceId, WebApplicationService service) {
        return this.samlObjectBuilder.newResponse(this.samlObjectBuilder.generateSecureRandomId(), ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(this.skewAllowance), serviceId, service);
    }

    public void setStatusRequestDenied(Response response, String description) {
        response.setStatus(this.samlObjectBuilder.newStatus(StatusCode.REQUEST_DENIED, description));
    }

    public void prepareSuccessfulResponse(Response response, WebApplicationService service, Authentication authentication, Principal principal, Map<String, List<Object>> authnAttributes, Map<String, List<Object>> principalAttributes) {
        ZonedDateTime issuedAt = DateTimeUtils.zonedDateTimeOf((Instant)response.getIssueInstant());
        LOGGER.debug("Preparing SAML response for service [{}]", (Object)service);
        Set authnMethods = CollectionUtils.toCollection(authentication.getAttributes().get("samlAuthenticationStatementAuthMethod"));
        LOGGER.debug("Authentication methods found are [{}]", (Object)authnMethods);
        AuthenticationStatement authnStatement = this.samlObjectBuilder.newAuthenticationStatement(authentication.getAuthenticationDate(), (Collection)authnMethods, principal.getId());
        LOGGER.debug("Built authentication statement for [{}] dated at [{}]", (Object)principal, (Object)authentication.getAuthenticationDate());
        Assertion assertion = this.samlObjectBuilder.newAssertion(authnStatement, this.issuer, issuedAt, this.samlObjectBuilder.generateSecureRandomId());
        LOGGER.debug("Built assertion for issuer [{}] dated at [{}]", (Object)this.issuer, (Object)issuedAt);
        Conditions conditions = this.samlObjectBuilder.newConditions(issuedAt, service.getId(), (long)this.issueLength);
        assertion.setConditions(conditions);
        LOGGER.debug("Built assertion conditions for issuer [{}] and service [{}] ", (Object)this.issuer, (Object)service.getId());
        Subject subject = this.samlObjectBuilder.newSubject(principal.getId());
        LOGGER.debug("Built subject for principal [{}]", (Object)subject);
        Map<String, Object> attributesToSend = this.prepareSamlAttributes(service, authnAttributes, principalAttributes);
        LOGGER.debug("Authentication statement shall include these attributes [{}]", attributesToSend);
        if (!attributesToSend.isEmpty()) {
            assertion.getAttributeStatements().add(this.samlObjectBuilder.newAttributeStatement(subject, attributesToSend, this.defaultAttributeNamespace));
        }
        response.setStatus(this.samlObjectBuilder.newStatus(StatusCode.SUCCESS, null));
        LOGGER.debug("Set response status code to [{}]", (Object)response.getStatus());
        response.getAssertions().add(assertion);
    }

    public void encodeSamlResponse(Response samlResponse, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.samlObjectBuilder.encodeSamlResponse(response, request, samlResponse);
    }

    private Map<String, Object> prepareSamlAttributes(WebApplicationService service, Map<String, List<Object>> authnAttributes, Map<String, List<Object>> principalAttributes) {
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        LOGGER.debug("Retrieved authentication attributes [{}] from the model", authnAttributes);
        HashMap<String, List<Object>> attributesToReturn = new HashMap<String, List<Object>>();
        attributesToReturn.putAll(principalAttributes);
        attributesToReturn.putAll(authnAttributes);
        LOGGER.debug("Beginning to encode attributes [{}] for service [{}]", attributesToReturn, (Object)registeredService.getServiceId());
        Map finalAttributes = this.protocolAttributeEncoder.encodeAttributes(attributesToReturn, registeredService, service);
        LOGGER.debug("Final collection of attributes are [{}]", (Object)finalAttributes);
        return finalAttributes;
    }

    @Generated
    public SamlResponseBuilder(Saml10ObjectBuilder samlObjectBuilder, String issuer, String defaultAttributeNamespace, int issueLength, int skewAllowance, ProtocolAttributeEncoder protocolAttributeEncoder, ServicesManager servicesManager) {
        this.samlObjectBuilder = samlObjectBuilder;
        this.issuer = issuer;
        this.defaultAttributeNamespace = defaultAttributeNamespace;
        this.issueLength = issueLength;
        this.skewAllowance = skewAllowance;
        this.protocolAttributeEncoder = protocolAttributeEncoder;
        this.servicesManager = servicesManager;
    }
}

