/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.util;

import java.security.SecureRandom;
import lombok.Generated;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.RandomUtils;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0001;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlCompliantUniqueTicketIdGenerator
implements UniqueTicketIdGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlCompliantUniqueTicketIdGenerator.class);
    private static final int ASSERTION_HANDLE_SIZE = 20;
    private static final byte[] ENDPOINT_ID = new byte[]{0, 1};
    private final byte[] sourceIdDigest;
    private boolean saml2compliant;
    private final SecureRandom random;

    public SamlCompliantUniqueTicketIdGenerator(String sourceId) {
        try {
            this.sourceIdDigest = DigestUtils.rawDigest((String)"SHA", (byte[])sourceId.getBytes("8859_1"));
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception generating digest of source ID.", e);
        }
        this.random = RandomUtils.getNativeInstance();
    }

    public String getNewTicketId(String prefix) {
        Object artifact = this.saml2compliant ? new SAML2ArtifactType0004(ENDPOINT_ID, this.newAssertionHandle(), this.sourceIdDigest) : new SAML1ArtifactType0001(this.sourceIdDigest, this.newAssertionHandle());
        return prefix + '-' + artifact.base64Encode();
    }

    private byte[] newAssertionHandle() {
        byte[] handle = new byte[20];
        this.random.nextBytes(handle);
        return handle;
    }

    @Generated
    public void setSaml2compliant(boolean saml2compliant) {
        this.saml2compliant = saml2compliant;
    }
}

