/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.authentication.principal;

import java.io.BufferedReader;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.apereo.cas.authentication.principal.AbstractServiceFactory;
import org.apereo.cas.support.saml.authentication.principal.SamlService;
import org.apereo.cas.support.saml.util.Saml10ObjectBuilder;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;

public class SamlServiceFactory
extends AbstractServiceFactory<SamlService> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlServiceFactory.class);
    private static final Namespace NAMESPACE_ENVELOPE = Namespace.getNamespace((String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static final Namespace NAMESPACE_SAML1 = Namespace.getNamespace((String)"urn:oasis:names:tc:SAML:1.0:protocol");
    private final Saml10ObjectBuilder saml10ObjectBuilder;

    public SamlService createService(HttpServletRequest request) {
        String service = request.getParameter("TARGET");
        String requestBody = request.getMethod().equalsIgnoreCase(HttpMethod.POST.name()) ? SamlServiceFactory.getRequestBody(request) : null;
        String artifactId = null;
        String requestId = null;
        if (!StringUtils.hasText((String)service) && !StringUtils.hasText((String)requestBody)) {
            LOGGER.trace("Request does not specify a [{}] or request body is empty", (Object)"TARGET");
            return null;
        }
        String id = SamlServiceFactory.cleanupUrl((String)service);
        if (StringUtils.hasText((String)requestBody)) {
            request.setAttribute("SAMLRequest", (Object)requestBody);
            Document document = Saml10ObjectBuilder.constructDocumentFromXml(requestBody);
            Element root = document.getRootElement();
            Element body = root.getChild("Body", NAMESPACE_ENVELOPE);
            Element requestChild = body.getChild("Request", NAMESPACE_SAML1);
            Element artifactElement = requestChild.getChild("AssertionArtifact", NAMESPACE_SAML1);
            artifactId = artifactElement.getValue();
            Attribute requestIdAttribute = requestChild.getAttribute("RequestID");
            if (requestIdAttribute == null) {
                LOGGER.error("SAML request body does not specify the RequestID attribute. This is a required attribute per the schema definition and MUST be provided by the client.  RequestID needs to be unique on a per-request basis and per OWASP, it may be 16 bytes of entropy in session identifiers which have similar requirements. While CAS does allow the RequestID attribute to be optional for the time being to preserve backward compatibility, this behavior MUST be fixed by the client and future CAS versions begin to enforce the presence of RequestID more forcefully to remain compliant with schema and protocol.");
            } else {
                requestId = requestIdAttribute.getValue();
            }
        }
        LOGGER.debug("Request Body: [{}]\n\"Extracted ArtifactId: [{}]. Extracted Request Id: [{}]", new Object[]{requestBody, artifactId, requestId});
        SamlService samlService = new SamlService(id, service, artifactId, requestId);
        samlService.setSource("TARGET");
        return samlService;
    }

    public SamlService createService(String id) {
        throw new NotImplementedException("This operation is not supported. ");
    }

    private static String getRequestBody(HttpServletRequest request) {
        String body = null;
        try (BufferedReader reader = request.getReader();){
            if (reader == null) {
                LOGGER.debug("Request body could not be read because it's empty.");
            } else {
                body = reader.lines().collect(Collectors.joining());
            }
        }
        catch (Exception e) {
            LOGGER.trace("Could not obtain the saml request body from the http request", (Throwable)e);
        }
        if (!StringUtils.hasText(body)) {
            LOGGER.trace("Looking at the request attribute [{}] to locate SAML request body", (Object)"SAMLRequest");
            body = (String)request.getAttribute("SAMLRequest");
            LOGGER.trace("Located cached saml request body [{}] as a request attribute", (Object)body);
        }
        return body;
    }

    @Generated
    public SamlServiceFactory(Saml10ObjectBuilder saml10ObjectBuilder) {
        this.saml10ObjectBuilder = saml10ObjectBuilder;
    }
}

