/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.util;

import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.util.CompressionUtils;
import org.apereo.cas.util.EncodingUtils;

public class NonInflatingSaml20ObjectBuilder
extends AbstractSaml20ObjectBuilder {
    public NonInflatingSaml20ObjectBuilder(OpenSamlConfigBean configBean) {
        super(configBean);
    }

    @Override
    public String decodeSamlAuthnRequest(String encodedRequestXmlString) {
        if (StringUtils.isEmpty((CharSequence)encodedRequestXmlString)) {
            return null;
        }
        byte[] decodedBytes = EncodingUtils.decodeBase64((String)encodedRequestXmlString);
        if (decodedBytes == null) {
            return null;
        }
        String inflated = CompressionUtils.decodeByteArrayToString((byte[])decodedBytes);
        if (!StringUtils.isEmpty((CharSequence)inflated)) {
            return inflated;
        }
        return new String(decodedBytes, StandardCharsets.UTF_8);
    }
}

