/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.util;

import java.net.InetAddress;
import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.util.AbstractSamlObjectBuilder;
import org.apereo.cas.util.CompressionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.InetAddressUtils;
import org.apereo.cas.util.RandomUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Statement;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.ecp.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaml20ObjectBuilder
extends AbstractSamlObjectBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSaml20ObjectBuilder.class);
    private static final int HEX_HIGH_BITS_BITWISE_FLAG = 15;
    private static final long serialVersionUID = -4325127376598205277L;

    public AbstractSaml20ObjectBuilder(OpenSamlConfigBean configBean) {
        super(configBean);
    }

    public NameID getNameID(String nameIdFormat, String nameIdValue) {
        NameID nameId = this.newSamlObject(NameID.class);
        nameId.setFormat(nameIdFormat);
        nameId.setValue(nameIdValue);
        return nameId;
    }

    public Response newEcpResponse(String assertionConsumerUrl) {
        Response samlResponse = this.newSamlObject(Response.class);
        samlResponse.setSOAP11MustUnderstand(Boolean.TRUE);
        samlResponse.setSOAP11Actor("http://schemas.xmlsoap.org/soap/actor/next");
        samlResponse.setAssertionConsumerServiceURL(assertionConsumerUrl);
        return samlResponse;
    }

    public org.opensaml.saml.saml2.core.Response newResponse(String id, ZonedDateTime issueInstant, String recipient, WebApplicationService service) {
        org.opensaml.saml.saml2.core.Response samlResponse = this.newSamlObject(org.opensaml.saml.saml2.core.Response.class);
        samlResponse.setID(id);
        samlResponse.setIssueInstant(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)issueInstant));
        samlResponse.setVersion(SAMLVersion.VERSION_20);
        if (StringUtils.isNotBlank((CharSequence)recipient)) {
            LOGGER.debug("Setting provided RequestId {} as InResponseTo", (Object)recipient);
            samlResponse.setInResponseTo(recipient);
        } else {
            LOGGER.debug("No recipient is provided. Skipping InResponseTo");
        }
        return samlResponse;
    }

    public Status newStatus(String codeValue, String statusMessage) {
        Status status = this.newSamlObject(Status.class);
        StatusCode statusCode = this.newSamlObject(StatusCode.class);
        statusCode.setValue(codeValue);
        status.setStatusCode(statusCode);
        if (StringUtils.isNotBlank((CharSequence)statusMessage)) {
            StatusMessage message = this.newSamlObject(StatusMessage.class);
            message.setMessage(statusMessage);
            status.setStatusMessage(message);
        }
        return status;
    }

    public Assertion newAssertion(AuthnStatement authnStatement, String issuer, ZonedDateTime issuedAt, String id) {
        ArrayList<Statement> list = new ArrayList<Statement>();
        list.add((Statement)authnStatement);
        return this.newAssertion(list, issuer, issuedAt, id);
    }

    public Assertion newAssertion(List<Statement> authnStatement, String issuer, ZonedDateTime issuedAt, String id) {
        Assertion assertion = this.newSamlObject(Assertion.class);
        assertion.setID(id);
        assertion.setIssueInstant(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)issuedAt));
        assertion.setIssuer(this.newIssuer(issuer));
        assertion.getStatements().addAll(authnStatement);
        return assertion;
    }

    public Issuer newIssuer(String issuerValue) {
        Issuer issuer = this.newSamlObject(Issuer.class);
        issuer.setValue(issuerValue);
        return issuer;
    }

    public AttributeStatement newAttributeStatement(Map<String, Object> attributes, Map<String, String> attributeFriendlyNames, Map<String, String> configuredNameFormats, String defaultNameFormat) {
        AttributeStatement attrStatement = this.newSamlObject(AttributeStatement.class);
        for (Map.Entry<String, Object> e : attributes.entrySet()) {
            if (e.getValue() instanceof Collection && ((Collection)e.getValue()).isEmpty()) {
                LOGGER.info("Skipping attribute [{}] because it does not have any values.", (Object)e.getKey());
                continue;
            }
            String friendlyName = attributeFriendlyNames.getOrDefault(e.getKey(), null);
            Attribute attribute = this.newAttribute(friendlyName, e, configuredNameFormats, defaultNameFormat);
            attrStatement.getAttributes().add(attribute);
        }
        return attrStatement;
    }

    public void addAttributeValuesToSaml2Attribute(String attributeName, Object attributeValue, List<XMLObject> attributeList) {
        this.addAttributeValuesToSamlAttribute(attributeName, attributeValue, attributeList, AttributeValue.DEFAULT_ELEMENT_NAME);
    }

    protected Attribute newAttribute(String attributeFriendlyName, Map.Entry<String, Object> e, Map<String, String> configuredNameFormats, String defaultNameFormat) {
        Attribute attribute = this.newSamlObject(Attribute.class);
        attribute.setName(e.getKey());
        if (StringUtils.isNotBlank((CharSequence)attributeFriendlyName)) {
            attribute.setFriendlyName(attributeFriendlyName);
        } else {
            attribute.setFriendlyName(e.getKey());
        }
        this.addAttributeValuesToSaml2Attribute(e.getKey(), e.getValue(), attribute.getAttributeValues());
        if (!configuredNameFormats.isEmpty() && configuredNameFormats.containsKey(attribute.getName())) {
            String nameFormat = configuredNameFormats.get(attribute.getName());
            LOGGER.debug("Found name format [{}] for attribute [{}]", (Object)nameFormat, (Object)attribute.getName());
            AbstractSaml20ObjectBuilder.configureAttributeNameFormat(attribute, nameFormat);
            LOGGER.debug("Attribute [{}] is assigned the name format of [{}]", (Object)attribute.getName(), (Object)attribute.getNameFormat());
        } else {
            LOGGER.debug("Skipped name format, as no name formats are defined or none is found for attribute [{}]", (Object)attribute.getName());
            AbstractSaml20ObjectBuilder.configureAttributeNameFormat(attribute, defaultNameFormat);
        }
        LOGGER.debug("Attribute [{}] has [{}] value(s)", (Object)attribute.getName(), (Object)attribute.getAttributeValues().size());
        return attribute;
    }

    private static void configureAttributeNameFormat(Attribute attribute, String nameFormat) {
        if (StringUtils.isBlank((CharSequence)nameFormat)) {
            return;
        }
        String compareFormat = nameFormat.trim().toLowerCase();
        if ("basic".equals(compareFormat) || compareFormat.equals("urn:oasis:names:tc:SAML:2.0:attrname-format:basic")) {
            attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        } else if ("uri".equals(compareFormat) || compareFormat.equals("urn:oasis:names:tc:SAML:2.0:attrname-format:uri")) {
            attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        } else if ("unspecified".equals(compareFormat) || compareFormat.equals("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified")) {
            attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
        } else {
            attribute.setNameFormat(nameFormat);
        }
    }

    public AuthnStatement newAuthnStatement(String contextClassRef, ZonedDateTime authnInstant, String sessionIndex) {
        LOGGER.debug("Building authentication statement with context class ref [{}] @ [{}] with index [{}]", new Object[]{contextClassRef, authnInstant, sessionIndex});
        AuthnStatement stmt = this.newSamlObject(AuthnStatement.class);
        AuthnContext ctx = this.newSamlObject(AuthnContext.class);
        AuthnContextClassRef classRef = this.newSamlObject(AuthnContextClassRef.class);
        classRef.setAuthnContextClassRef(contextClassRef);
        ctx.setAuthnContextClassRef(classRef);
        stmt.setAuthnContext(ctx);
        stmt.setAuthnInstant(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)authnInstant));
        stmt.setSessionIndex(sessionIndex);
        return stmt;
    }

    public Conditions newConditions(ZonedDateTime notBefore, ZonedDateTime notOnOrAfter, String ... audienceUri) {
        LOGGER.debug("Building conditions for audience [{}] that enforce not-before [{}] and not-after [{}]", new Object[]{audienceUri, notBefore, notOnOrAfter});
        Conditions conditions = this.newSamlObject(Conditions.class);
        conditions.setNotBefore(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)notBefore));
        conditions.setNotOnOrAfter(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)notOnOrAfter));
        AudienceRestriction audienceRestriction = this.newSamlObject(AudienceRestriction.class);
        Arrays.stream(audienceUri).forEach(audienceEntry -> {
            Audience audience = this.newSamlObject(Audience.class);
            audience.setAudienceURI(audienceEntry);
            audienceRestriction.getAudiences().add(audience);
        });
        conditions.getAudienceRestrictions().add(audienceRestriction);
        return conditions;
    }

    public Subject newSubject(String nameIdFormat, String nameIdValue, String recipient, ZonedDateTime notOnOrAfter, String inResponseTo, ZonedDateTime notBefore) {
        NameID nameID = this.getNameID(nameIdFormat, nameIdValue);
        return this.newSubject(nameID, recipient, notOnOrAfter, inResponseTo, notBefore);
    }

    public Subject newSubject(NameID nameId, String recipient, ZonedDateTime notOnOrAfter, String inResponseTo, ZonedDateTime notBefore) {
        LOGGER.debug("Building subject for NameID [{}] and recipient [{}], in response to [{}]", new Object[]{nameId, recipient, inResponseTo});
        SubjectConfirmation confirmation = this.newSamlObject(SubjectConfirmation.class);
        confirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SubjectConfirmationData data = this.newSamlObject(SubjectConfirmationData.class);
        if (StringUtils.isNotBlank((CharSequence)recipient)) {
            data.setRecipient(recipient);
        }
        if (notOnOrAfter != null) {
            data.setNotOnOrAfter(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)notOnOrAfter));
        }
        if (StringUtils.isNotBlank((CharSequence)inResponseTo)) {
            data.setInResponseTo(inResponseTo);
            InetAddress ip = InetAddressUtils.getByName((String)inResponseTo);
            if (ip != null) {
                data.setAddress(ip.getHostName());
            }
        }
        if (notBefore != null) {
            data.setNotBefore(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)notBefore));
        }
        confirmation.setSubjectConfirmationData(data);
        Subject subject = this.newSamlObject(Subject.class);
        if (nameId != null) {
            subject.setNameID(nameId);
        }
        subject.getSubjectConfirmations().add(confirmation);
        LOGGER.debug("Built subject [{}]", (Object)subject);
        return subject;
    }

    @Override
    public String generateSecureRandomId() {
        SecureRandom generator = RandomUtils.getNativeInstance();
        char[] charMappings = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
        int charsLength = 40;
        int generatorBytesLength = 20;
        int shiftLength = 4;
        byte[] bytes = new byte[20];
        generator.nextBytes(bytes);
        char[] chars = new char[40];
        IntStream.range(0, bytes.length).forEach(i -> {
            int left = bytes[i] >> 4 & 0xF;
            int right = bytes[i] & 0xF;
            chars[i * 2] = charMappings[left];
            chars[i * 2 + 1] = charMappings[right];
        });
        return String.valueOf(chars);
    }

    public String decodeSamlAuthnRequest(String encodedRequestXmlString) {
        if (StringUtils.isEmpty((CharSequence)encodedRequestXmlString)) {
            return null;
        }
        byte[] decodedBytes = EncodingUtils.decodeBase64((String)encodedRequestXmlString);
        if (decodedBytes == null) {
            return null;
        }
        String inflated = CompressionUtils.inflate((byte[])decodedBytes);
        if (!StringUtils.isEmpty((CharSequence)inflated)) {
            return inflated;
        }
        return CompressionUtils.decodeByteArrayToString((byte[])decodedBytes);
    }
}

