/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.authentication.principal;

import java.io.BufferedReader;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.NotImplementedException;
import org.apereo.cas.authentication.principal.AbstractServiceFactory;
import org.apereo.cas.support.saml.authentication.principal.SamlService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SamlServiceFactory
extends AbstractServiceFactory<SamlService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlServiceFactory.class);
    private static final int CONST_REQUEST_ID_LENGTH = 11;
    private static final String CONST_START_ARTIFACT_XML_TAG_NO_NAMESPACE = "<AssertionArtifact>";
    private static final String CONST_END_ARTIFACT_XML_TAG_NO_NAMESPACE = "</AssertionArtifact>";
    private static final String CONST_START_ARTIFACT_XML_TAG = "<samlp:AssertionArtifact>";
    private static final String CONST_END_ARTIFACT_XML_TAG = "</samlp:AssertionArtifact>";

    public SamlService createService(HttpServletRequest request) {
        String requestId;
        String artifactId;
        String service = request.getParameter("TARGET");
        String requestBody = SamlServiceFactory.getRequestBody(request);
        if (!StringUtils.hasText((String)service) && !StringUtils.hasText((String)requestBody)) {
            LOGGER.debug("Request does not specify a [{}] or request body is empty", (Object)"TARGET");
            return null;
        }
        String id = SamlServiceFactory.cleanupUrl((String)service);
        if (StringUtils.hasText((String)requestBody)) {
            String tagEnd;
            String tagStart;
            if (requestBody.contains(CONST_START_ARTIFACT_XML_TAG)) {
                tagStart = CONST_START_ARTIFACT_XML_TAG;
                tagEnd = CONST_END_ARTIFACT_XML_TAG;
            } else {
                tagStart = CONST_START_ARTIFACT_XML_TAG_NO_NAMESPACE;
                tagEnd = CONST_END_ARTIFACT_XML_TAG_NO_NAMESPACE;
            }
            int startTagLocation = requestBody.indexOf(tagStart);
            int artifactStartLocation = startTagLocation + tagStart.length();
            int endTagLocation = requestBody.indexOf(tagEnd);
            artifactId = requestBody.substring(artifactStartLocation, endTagLocation).trim();
            requestId = SamlServiceFactory.extractRequestId(requestBody);
        } else {
            artifactId = null;
            requestId = null;
        }
        LOGGER.debug("Request Body: [{}]", (Object)requestBody);
        LOGGER.debug("Extracted ArtifactId: [{}]. extracted Request Id: [{}]", artifactId, requestId);
        return new SamlService(id, service, artifactId, requestId);
    }

    public SamlService createService(String id) {
        throw new NotImplementedException("This operation is not supported. ");
    }

    private static String extractRequestId(String requestBody) {
        if (!requestBody.contains("RequestID")) {
            LOGGER.debug("Request body does not contain a request id");
            return null;
        }
        try {
            int position = requestBody.indexOf("RequestID=\"") + 11;
            int nextPosition = requestBody.indexOf(34, position);
            return requestBody.substring(position, nextPosition);
        }
        catch (Exception e) {
            LOGGER.debug("Exception parsing RequestID from request.", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getRequestBody(HttpServletRequest request) {
        try (BufferedReader reader = request.getReader();){
            if (reader == null) {
                LOGGER.debug("Request body could not be read because it's empty.");
                String string2 = null;
                return string2;
            }
            String string = reader.lines().collect(Collectors.joining());
            return string;
        }
        catch (Exception e) {
            LOGGER.trace("Could not obtain the saml request body from the http request", (Throwable)e);
            return null;
        }
    }
}

