/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.view;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.web.support.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.support.saml.util.Saml10ObjectBuilder;
import org.apereo.cas.support.saml.web.view.AbstractSaml10ResponseView;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.joda.time.ReadableInstant;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.StatusCode;
import org.opensaml.saml.saml1.core.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Saml10SuccessResponseView
extends AbstractSaml10ResponseView {
    private static final Logger LOGGER = LoggerFactory.getLogger(Saml10SuccessResponseView.class);
    private final String issuer;
    private final String rememberMeAttributeName;
    private final String defaultAttributeNamespace;

    public Saml10SuccessResponseView(ProtocolAttributeEncoder protocolAttributeEncoder, ServicesManager servicesManager, String authenticationContextAttribute, Saml10ObjectBuilder samlObjectBuilder, ArgumentExtractor samlArgumentExtractor, String encoding, int skewAllowance, int issueLength, String issuer, String defaultAttributeNamespace, AuthenticationAttributeReleasePolicy authAttrReleasePolicy) {
        super(true, protocolAttributeEncoder, servicesManager, authenticationContextAttribute, samlObjectBuilder, samlArgumentExtractor, encoding, skewAllowance, issueLength, authAttrReleasePolicy);
        this.issuer = issuer;
        this.rememberMeAttributeName = "longTermAuthenticationRequestTokenUsed";
        this.defaultAttributeNamespace = defaultAttributeNamespace;
    }

    @Override
    protected void prepareResponse(Response response, Map<String, Object> model) {
        ZonedDateTime issuedAt = DateTimeUtils.zonedDateTimeOf((ReadableInstant)response.getIssueInstant());
        Service service = this.getAssertionFrom(model).getService();
        LOGGER.debug("Preparing SAML response for service [{}]", (Object)service);
        Authentication authentication = this.getPrimaryAuthenticationFrom(model);
        Set authnMethods = CollectionUtils.toCollection(authentication.getAttributes().get("samlAuthenticationStatementAuthMethod"));
        LOGGER.debug("Authentication methods found are [{}]", (Object)authnMethods);
        Principal principal = this.getPrincipal(model);
        AuthenticationStatement authnStatement = this.samlObjectBuilder.newAuthenticationStatement(authentication.getAuthenticationDate(), authnMethods, principal.getId());
        LOGGER.debug("Built authentication statement for [{}] dated at [{}]", (Object)principal, (Object)authentication.getAuthenticationDate());
        Assertion assertion = this.samlObjectBuilder.newAssertion(authnStatement, this.issuer, issuedAt, this.samlObjectBuilder.generateSecureRandomId());
        LOGGER.debug("Built assertion for issuer [{}] dated at [{}]", (Object)this.issuer, (Object)issuedAt);
        Conditions conditions = this.samlObjectBuilder.newConditions(issuedAt, service.getId(), this.issueLength);
        assertion.setConditions(conditions);
        LOGGER.debug("Built assertion conditions for issuer [{}] and service [{}] ", (Object)this.issuer, (Object)service.getId());
        Subject subject = this.samlObjectBuilder.newSubject(principal.getId());
        LOGGER.debug("Built subject for principal [{}]", (Object)principal);
        Map<String, Object> attributesToSend = this.prepareSamlAttributes(model, service);
        LOGGER.debug("Authentication statement shall include these attributes [{}]", attributesToSend);
        if (!attributesToSend.isEmpty()) {
            assertion.getAttributeStatements().add(this.samlObjectBuilder.newAttributeStatement(subject, attributesToSend, this.defaultAttributeNamespace));
        }
        response.setStatus(this.samlObjectBuilder.newStatus(StatusCode.SUCCESS, null));
        LOGGER.debug("Set response status code to [{}]", (Object)response.getStatus());
        response.getAssertions().add(assertion);
    }

    private Map<String, Object> prepareSamlAttributes(Map<String, Object> model, Service service) {
        Map authnAttributes = this.authenticationAttributeReleasePolicy.getAuthenticationAttributesForRelease(this.getPrimaryAuthenticationFrom(model));
        if (this.isRememberMeAuthentication(model)) {
            authnAttributes.put(this.rememberMeAttributeName, Boolean.TRUE.toString());
        }
        LOGGER.debug("Retrieved authentication attributes [{}] from the model", (Object)authnAttributes);
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        HashMap attributesToReturn = new HashMap();
        attributesToReturn.putAll(this.getPrincipalAttributesAsMultiValuedAttributes(model));
        attributesToReturn.putAll(authnAttributes);
        this.decideIfCredentialPasswordShouldBeReleasedAsAttribute(attributesToReturn, model, registeredService);
        this.decideIfProxyGrantingTicketShouldBeReleasedAsAttribute(attributesToReturn, model, registeredService);
        LOGGER.debug("Beginning to encode attributes [{}] for service [{}]", attributesToReturn, (Object)registeredService.getServiceId());
        Map finalAttributes = this.protocolAttributeEncoder.encodeAttributes(attributesToReturn, registeredService);
        LOGGER.debug("Final collection of attributes are [{}]", (Object)finalAttributes);
        return finalAttributes;
    }
}

