/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.authentication;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HttpBasedServiceCredential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.metadata.BaseAuthenticationMetadataPopulator;

public class SamlAuthenticationMetaDataPopulator
extends BaseAuthenticationMetadataPopulator {
    public static final String ATTRIBUTE_AUTHENTICATION_METHOD = "samlAuthenticationStatementAuthMethod";
    public static final String AUTHN_METHOD_PASSWORD = "urn:oasis:names:tc:SAML:1.0:am:password";
    public static final String AUTHN_METHOD_SSL_TLS_CLIENT = "urn:ietf:rfc:2246";
    public static final String AUTHN_METHOD_X509_PUBLICKEY = "urn:oasis:names:tc:SAML:1.0:am:X509-PKI";
    public static final String AUTHN_METHOD_UNSPECIFIED = "urn:oasis:names:tc:SAML:1.0:am:unspecified";
    private Map<String, String> authenticationMethods = new HashMap<String, String>();

    public SamlAuthenticationMetaDataPopulator() {
        this.authenticationMethods.put(HttpBasedServiceCredential.class.getName(), AUTHN_METHOD_SSL_TLS_CLIENT);
        this.authenticationMethods.put(UsernamePasswordCredential.class.getName(), AUTHN_METHOD_PASSWORD);
        this.authenticationMethods.put("org.apereo.cas.adaptors.trusted.authentication.principal.PrincipalBearingCredentials", AUTHN_METHOD_UNSPECIFIED);
        this.authenticationMethods.put("org.apereo.cas.adaptors.x509.authentication.principal.X509CertificateCredentials", AUTHN_METHOD_X509_PUBLICKEY);
    }

    public void populateAttributes(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        String credentialsClass = transaction.getCredential().getClass().getName();
        String authenticationMethod = this.authenticationMethods.get(credentialsClass);
        builder.addAttribute(ATTRIBUTE_AUTHENTICATION_METHOD, (Object)authenticationMethod);
    }

    public boolean supports(Credential credential) {
        return true;
    }

    public void setUserDefinedMappings(Map<String, String> userDefinedMappings) {
        this.authenticationMethods.putAll(userDefinedMappings);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("authenticationMethods", this.authenticationMethods).toString();
    }
}

