/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.util;

import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.saml.authentication.principal.SamlService;
import org.apereo.cas.support.saml.util.AbstractSamlObjectBuilder;
import org.apereo.cas.util.CompressionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.EncodingUtils;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Statement;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;

public abstract class AbstractSaml20ObjectBuilder
extends AbstractSamlObjectBuilder {
    private static final int HEX_HIGH_BITS_BITWISE_FLAG = 15;
    private static final long serialVersionUID = -4325127376598205277L;

    protected NameID getNameID(String nameIdFormat, String nameIdValue) {
        NameID nameId = this.newSamlObject(NameID.class);
        nameId.setFormat(nameIdFormat);
        nameId.setValue(nameIdValue);
        return nameId;
    }

    public Response newResponse(String id, ZonedDateTime issueInstant, String recipient, WebApplicationService service) {
        SamlService samlService;
        String requestId;
        Response samlResponse = this.newSamlObject(Response.class);
        samlResponse.setID(id);
        samlResponse.setIssueInstant(DateTimeUtils.dateTimeOf((ZonedDateTime)issueInstant));
        samlResponse.setVersion(SAMLVersion.VERSION_20);
        samlResponse.setInResponseTo(recipient);
        if (service instanceof SamlService && StringUtils.isNotBlank((String)(requestId = (samlService = (SamlService)service).getRequestID()))) {
            samlResponse.setInResponseTo(requestId);
        }
        return samlResponse;
    }

    public Status newStatus(String codeValue, String statusMessage) {
        Status status = this.newSamlObject(Status.class);
        StatusCode code = this.newSamlObject(StatusCode.class);
        code.setValue(codeValue);
        status.setStatusCode(code);
        if (StringUtils.isNotBlank((String)statusMessage)) {
            StatusMessage message = this.newSamlObject(StatusMessage.class);
            message.setMessage(statusMessage);
            status.setStatusMessage(message);
        }
        return status;
    }

    public Assertion newAssertion(AuthnStatement authnStatement, String issuer, ZonedDateTime issuedAt, String id) {
        ArrayList<Statement> list = new ArrayList<Statement>();
        list.add((Statement)authnStatement);
        return this.newAssertion(list, issuer, issuedAt, id);
    }

    public Assertion newAssertion(List<Statement> authnStatement, String issuer, ZonedDateTime issuedAt, String id) {
        Assertion assertion = this.newSamlObject(Assertion.class);
        assertion.setID(id);
        assertion.setIssueInstant(DateTimeUtils.dateTimeOf((ZonedDateTime)issuedAt));
        assertion.setIssuer(this.newIssuer(issuer));
        assertion.getStatements().addAll(authnStatement);
        return assertion;
    }

    public Issuer newIssuer(String issuerValue) {
        Issuer issuer = this.newSamlObject(Issuer.class);
        issuer.setValue(issuerValue);
        return issuer;
    }

    public AttributeStatement newAttributeStatement(Map<String, Object> attributes, boolean setFriendlyName) {
        AttributeStatement attrStatement = this.newSamlObject(AttributeStatement.class);
        for (Map.Entry<String, Object> e : attributes.entrySet()) {
            if (e.getValue() instanceof Collection && ((Collection)e.getValue()).isEmpty()) {
                this.logger.info("Skipping attribute {} because it does not have any values.", (Object)e.getKey());
                continue;
            }
            Attribute attribute = this.newSamlObject(Attribute.class);
            attribute.setName(e.getKey());
            if (setFriendlyName) {
                attribute.setFriendlyName(e.getKey());
            }
            if (e.getValue() instanceof Collection) {
                Collection c = (Collection)e.getValue();
                for (Object value : c) {
                    attribute.getAttributeValues().add(this.newAttributeValue(value, AttributeValue.DEFAULT_ELEMENT_NAME));
                }
            } else {
                attribute.getAttributeValues().add(this.newAttributeValue(e.getValue(), AttributeValue.DEFAULT_ELEMENT_NAME));
            }
            attrStatement.getAttributes().add(attribute);
        }
        return attrStatement;
    }

    public AuthnStatement newAuthnStatement(String contextClassRef, ZonedDateTime authnInstant) {
        AuthnStatement stmt = this.newSamlObject(AuthnStatement.class);
        AuthnContext ctx = this.newSamlObject(AuthnContext.class);
        AuthnContextClassRef classRef = this.newSamlObject(AuthnContextClassRef.class);
        classRef.setAuthnContextClassRef(contextClassRef);
        ctx.setAuthnContextClassRef(classRef);
        stmt.setAuthnContext(ctx);
        stmt.setAuthnInstant(DateTimeUtils.dateTimeOf((ZonedDateTime)authnInstant));
        return stmt;
    }

    public Conditions newConditions(ZonedDateTime notBefore, ZonedDateTime notOnOrAfter, String audienceUri) {
        Conditions conditions = this.newSamlObject(Conditions.class);
        conditions.setNotBefore(DateTimeUtils.dateTimeOf((ZonedDateTime)notBefore));
        conditions.setNotOnOrAfter(DateTimeUtils.dateTimeOf((ZonedDateTime)notOnOrAfter));
        AudienceRestriction audienceRestriction = this.newSamlObject(AudienceRestriction.class);
        Audience audience = this.newSamlObject(Audience.class);
        audience.setAudienceURI(audienceUri);
        audienceRestriction.getAudiences().add(audience);
        conditions.getAudienceRestrictions().add(audienceRestriction);
        return conditions;
    }

    public Subject newSubject(String nameIdFormat, String nameIdValue, String recipient, ZonedDateTime notOnOrAfter, String inResponseTo) {
        SubjectConfirmation confirmation = this.newSamlObject(SubjectConfirmation.class);
        confirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SubjectConfirmationData data = this.newSamlObject(SubjectConfirmationData.class);
        data.setRecipient(recipient);
        data.setNotOnOrAfter(DateTimeUtils.dateTimeOf((ZonedDateTime)notOnOrAfter));
        data.setInResponseTo(inResponseTo);
        confirmation.setSubjectConfirmationData(data);
        Subject subject = this.newSamlObject(Subject.class);
        subject.setNameID(this.getNameID(nameIdFormat, nameIdValue));
        subject.getSubjectConfirmations().add(confirmation);
        return subject;
    }

    @Override
    public String generateSecureRandomId() {
        SecureRandom generator = new SecureRandom();
        char[] charMappings = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
        int charsLength = 40;
        int generatorBytesLength = 20;
        int shiftLength = 4;
        byte[] bytes = new byte[20];
        generator.nextBytes(bytes);
        char[] chars = new char[40];
        for (int i = 0; i < bytes.length; ++i) {
            int left = bytes[i] >> 4 & 0xF;
            int right = bytes[i] & 0xF;
            chars[i * 2] = charMappings[left];
            chars[i * 2 + 1] = charMappings[right];
        }
        return String.valueOf(chars);
    }

    public String decodeSamlAuthnRequest(String encodedRequestXmlString) {
        if (StringUtils.isEmpty((String)encodedRequestXmlString)) {
            return null;
        }
        byte[] decodedBytes = EncodingUtils.decodeBase64((String)encodedRequestXmlString);
        if (decodedBytes == null) {
            return null;
        }
        String inflated = CompressionUtils.inflate((byte[])decodedBytes);
        if (!StringUtils.isEmpty((String)inflated)) {
            return inflated;
        }
        return CompressionUtils.decodeByteArrayToString((byte[])decodedBytes);
    }
}

