/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.view;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.web.view.AbstractCasView;
import org.apereo.cas.support.saml.authentication.principal.SamlServiceFactory;
import org.apereo.cas.support.saml.util.Saml10ObjectBuilder;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.DefaultArgumentExtractor;
import org.opensaml.saml.saml1.core.Response;

public abstract class AbstractSaml10ResponseView
extends AbstractCasView {
    protected Saml10ObjectBuilder samlObjectBuilder;
    private ArgumentExtractor samlArgumentExtractor;
    private String encoding = StandardCharsets.UTF_8.name();
    private int skewAllowance;

    public AbstractSaml10ResponseView() {
        this.samlArgumentExtractor = new DefaultArgumentExtractor((ServiceFactory)new SamlServiceFactory());
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSkewAllowance(int skewAllowance) {
        this.logger.debug("Using {} seconds as skew allowance.", (Object)skewAllowance);
        this.skewAllowance = skewAllowance;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String serviceId = null;
        try {
            response.setCharacterEncoding(this.encoding);
            WebApplicationService service = this.samlArgumentExtractor.extractService(request);
            if (service == null || StringUtils.isBlank((CharSequence)service.getId())) {
                serviceId = "UNKNOWN";
            } else {
                try {
                    serviceId = new URL(service.getId()).getHost();
                }
                catch (MalformedURLException e) {
                    this.logger.debug(e.getMessage(), (Throwable)e);
                }
            }
            this.logger.debug("Using {} as the recipient of the SAML response for {}", (Object)serviceId, (Object)service);
            Response samlResponse = this.samlObjectBuilder.newResponse(this.samlObjectBuilder.generateSecureRandomId(), ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(this.skewAllowance), serviceId, service);
            this.prepareResponse(samlResponse, model);
            this.samlObjectBuilder.encodeSamlResponse(response, request, samlResponse);
        }
        catch (Exception e) {
            this.logger.error("Error generating SAML response for service {}.", serviceId, (Object)e);
            throw e;
        }
    }

    public void setSamlObjectBuilder(Saml10ObjectBuilder samlObjectBuilder) {
        this.samlObjectBuilder = samlObjectBuilder;
    }

    public void setSamlArgumentExtractor(ArgumentExtractor samlArgumentExtractor) {
        this.samlArgumentExtractor = samlArgumentExtractor;
    }

    protected abstract void prepareResponse(Response var1, Map<String, Object> var2);
}

