/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.util.DigestUtils;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0001;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;

public class SamlCompliantUniqueTicketIdGenerator
implements UniqueTicketIdGenerator {
    private static final int ASSERTION_HANDLE_SIZE = 20;
    private static final byte[] ENDPOINT_ID = new byte[]{0, 1};
    private byte[] sourceIdDigest;
    private boolean saml2compliant;
    private SecureRandom random;

    public SamlCompliantUniqueTicketIdGenerator(String sourceId) {
        try {
            this.sourceIdDigest = DigestUtils.rawDigest((String)"SHA", (byte[])sourceId.getBytes("8859_1"));
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception generating digest of source ID.", e);
        }
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot get SHA1PRNG secure random instance.", e);
        }
    }

    public String getNewTicketId(String prefix) {
        if (this.saml2compliant) {
            return new SAML2ArtifactType0004(ENDPOINT_ID, this.newAssertionHandle(), this.sourceIdDigest).base64Encode();
        }
        return new SAML1ArtifactType0001(this.sourceIdDigest, this.newAssertionHandle()).base64Encode();
    }

    public void setSaml2compliant(boolean saml2compliant) {
        this.saml2compliant = saml2compliant;
    }

    private byte[] newAssertionHandle() {
        byte[] handle = new byte[20];
        this.random.nextBytes(handle);
        return handle;
    }
}

