/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.authentication.principal;

import java.io.BufferedReader;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.NotImplementedException;
import org.apereo.cas.authentication.principal.AbstractServiceFactory;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.saml.authentication.principal.SamlService;
import org.apereo.cas.support.saml.authentication.principal.SamlServiceResponseBuilder;
import org.springframework.util.StringUtils;

public class SamlServiceFactory
extends AbstractServiceFactory<SamlService> {
    private static final int CONST_REQUEST_ID_LENGTH = 11;
    private static final String CONST_START_ARTIFACT_XML_TAG_NO_NAMESPACE = "<AssertionArtifact>";
    private static final String CONST_END_ARTIFACT_XML_TAG_NO_NAMESPACE = "</AssertionArtifact>";
    private static final String CONST_START_ARTIFACT_XML_TAG = "<samlp:AssertionArtifact>";
    private static final String CONST_END_ARTIFACT_XML_TAG = "</samlp:AssertionArtifact>";

    public SamlService createService(HttpServletRequest request) {
        String requestId;
        String artifactId;
        String service = request.getParameter("TARGET");
        String requestBody = this.getRequestBody(request);
        if (!StringUtils.hasText((String)service) && !StringUtils.hasText((String)requestBody)) {
            this.logger.debug("Request does not specify a {} or request body is empty", (Object)"TARGET");
            return null;
        }
        String id = SamlServiceFactory.cleanupUrl((String)service);
        if (StringUtils.hasText((String)requestBody)) {
            String tagEnd;
            String tagStart;
            if (requestBody.contains(CONST_START_ARTIFACT_XML_TAG)) {
                tagStart = CONST_START_ARTIFACT_XML_TAG;
                tagEnd = CONST_END_ARTIFACT_XML_TAG;
            } else {
                tagStart = CONST_START_ARTIFACT_XML_TAG_NO_NAMESPACE;
                tagEnd = CONST_END_ARTIFACT_XML_TAG_NO_NAMESPACE;
            }
            int startTagLocation = requestBody.indexOf(tagStart);
            int artifactStartLocation = startTagLocation + tagStart.length();
            int endTagLocation = requestBody.indexOf(tagEnd);
            artifactId = requestBody.substring(artifactStartLocation, endTagLocation).trim();
            requestId = this.extractRequestId(requestBody);
        } else {
            artifactId = null;
            requestId = null;
        }
        this.logger.debug("Request Body: {}", (Object)requestBody);
        this.logger.debug("Extracted ArtifactId: {}. extracted Request Id: {}", artifactId, requestId);
        return new SamlService(id, service, artifactId, requestId, (ResponseBuilder<WebApplicationService>)new SamlServiceResponseBuilder());
    }

    public SamlService createService(String id) {
        throw new NotImplementedException("This operation is not supported. ");
    }

    private String extractRequestId(String requestBody) {
        if (!requestBody.contains("RequestID")) {
            this.logger.debug("Request body does not contain a request id");
            return null;
        }
        try {
            int position = requestBody.indexOf("RequestID=\"") + 11;
            int nextPosition = requestBody.indexOf(34, position);
            return requestBody.substring(position, nextPosition);
        }
        catch (Exception e) {
            this.logger.debug("Exception parsing RequestID from request.", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRequestBody(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line;
            if (reader == null) {
                this.logger.debug("Request body could not be read because it's empty.");
                String string2 = null;
                return string2;
            }
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            String string = builder.toString();
            return string;
        }
        catch (Exception e) {
            this.logger.trace("Could not obtain the saml request body from the http request", (Throwable)e);
            return null;
        }
    }
}

