/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.support.CasAttributeEncoder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.authentication.SamlAuthenticationMetaDataPopulator;
import org.apereo.cas.support.saml.authentication.principal.SamlService;
import org.apereo.cas.support.saml.authentication.principal.SamlServiceFactory;
import org.apereo.cas.support.saml.util.Saml10ObjectBuilder;
import org.apereo.cas.support.saml.util.SamlCompliantUniqueTicketIdGenerator;
import org.apereo.cas.support.saml.web.SamlValidateController;
import org.apereo.cas.support.saml.web.view.Saml10FailureResponseView;
import org.apereo.cas.support.saml.web.view.Saml10SuccessResponseView;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.validation.ValidationSpecification;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;

@Configuration(value="samlConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="casAttributeEncoder")
    private CasAttributeEncoder casAttributeEncoder;
    @Autowired
    @Qualifier(value="cas3ServiceJsonView")
    private View cas3ServiceJsonView;
    @Autowired
    @Qualifier(value="proxy20Handler")
    private ProxyHandler proxy20Handler;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private OpenSamlConfigBean configBean;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="authenticationContextValidator")
    private AuthenticationContextValidator authenticationContextValidator;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification")
    private ValidationSpecification cas20WithoutProxyProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="defaultArgumentExtractor")
    private ArgumentExtractor argumentExtractor;
    @Autowired
    @Qualifier(value="defaultMultifactorTriggerSelectionStrategy")
    private MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy;
    @Autowired
    @Qualifier(value="uniqueIdGeneratorsMap")
    private Map uniqueIdGeneratorsMap;
    @Autowired
    @Qualifier(value="authenticationMetadataPopulators")
    private List authenticationMetadataPopulators;

    @RefreshScope
    @Bean
    public View casSamlServiceSuccessView() {
        Saml10SuccessResponseView view = new Saml10SuccessResponseView();
        view.setServicesManager(this.servicesManager);
        view.setCasAttributeEncoder(this.casAttributeEncoder);
        view.setIssuer(this.casProperties.getSamlCore().getIssuer());
        view.setSkewAllowance(this.casProperties.getSamlCore().getSkewAllowance());
        view.setDefaultAttributeNamespace(this.casProperties.getSamlCore().getAttributeNamespace());
        view.setSamlObjectBuilder(this.saml10ObjectBuilder());
        view.setCasAttributeEncoder(this.casAttributeEncoder);
        return view;
    }

    @RefreshScope
    @Bean
    public View casSamlServiceFailureView() {
        Saml10FailureResponseView view = new Saml10FailureResponseView();
        view.setServicesManager(this.servicesManager);
        view.setCasAttributeEncoder(this.casAttributeEncoder);
        view.setSamlObjectBuilder(this.saml10ObjectBuilder());
        view.setCasAttributeEncoder(this.casAttributeEncoder);
        return view;
    }

    @Bean
    public AuthenticationMetaDataPopulator samlAuthenticationMetaDataPopulator() {
        return new SamlAuthenticationMetaDataPopulator();
    }

    @Bean
    public ServiceFactory<SamlService> samlServiceFactory() {
        return new SamlServiceFactory();
    }

    @Bean
    public Saml10ObjectBuilder saml10ObjectBuilder() {
        Saml10ObjectBuilder w = new Saml10ObjectBuilder();
        w.setConfigBean(this.configBean);
        return w;
    }

    @Bean
    public UniqueTicketIdGenerator samlServiceTicketUniqueIdGenerator() {
        SamlCompliantUniqueTicketIdGenerator gen = new SamlCompliantUniqueTicketIdGenerator(this.casProperties.getServer().getName());
        gen.setSaml2compliant(this.casProperties.getSamlCore().isTicketidSaml2());
        return gen;
    }

    @Bean
    public SamlValidateController samlValidateController() {
        SamlValidateController c = new SamlValidateController();
        c.setValidationSpecification(this.cas20WithoutProxyProtocolValidationSpecification);
        c.setSuccessView(this.casSamlServiceSuccessView());
        c.setFailureView(this.casSamlServiceFailureView());
        c.setProxyHandler(this.proxy20Handler);
        c.setAuthenticationSystemSupport(this.authenticationSystemSupport);
        c.setServicesManager(this.servicesManager);
        c.setCentralAuthenticationService(this.centralAuthenticationService);
        c.setArgumentExtractor(this.argumentExtractor);
        c.setMultifactorTriggerSelectionStrategy(this.multifactorTriggerSelectionStrategy);
        c.setAuthenticationContextValidator(this.authenticationContextValidator);
        c.setJsonView(this.cas3ServiceJsonView);
        c.setAuthnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        return c;
    }

    @PostConstruct
    protected void initializeRootApplicationContext() {
        this.argumentExtractor.getServiceFactories().add(0, this.samlServiceFactory());
        this.uniqueIdGeneratorsMap.put(SamlService.class.getCanonicalName(), this.samlServiceTicketUniqueIdGenerator());
        this.authenticationMetadataPopulators.add(0, this.samlAuthenticationMetaDataPopulator());
    }
}

