/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.support.rest.BadRequestException;
import org.apereo.cas.support.rest.CredentialFactory;
import org.apereo.cas.support.rest.factory.TicketGrantingTicketResourceEntityResponseFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="ticketResourceRestController")
public class TicketGrantingTicketResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketGrantingTicketResource.class);
    private final CentralAuthenticationService centralAuthenticationService;
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final ServiceFactory serviceFactory;
    private final CredentialFactory credentialFactory;
    private final TicketGrantingTicketResourceEntityResponseFactory ticketGrantingTicketResourceEntityResponseFactory;
    private final ObjectWriter jacksonPrettyWriter = new ObjectMapper().findAndRegisterModules().writer().withDefaultPrettyPrinter();

    public TicketGrantingTicketResource(AuthenticationSystemSupport authenticationSystemSupport, CredentialFactory credentialFactory, CentralAuthenticationService centralAuthenticationService, ServiceFactory serviceFactory, TicketGrantingTicketResourceEntityResponseFactory ticketGrantingTicketResourceEntityResponseFactory) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.credentialFactory = credentialFactory;
        this.centralAuthenticationService = centralAuthenticationService;
        this.serviceFactory = serviceFactory;
        this.ticketGrantingTicketResourceEntityResponseFactory = ticketGrantingTicketResourceEntityResponseFactory;
    }

    @PostMapping(value={"/v1/tickets"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<String> createTicketGrantingTicket(@RequestBody MultiValueMap<String, String> requestBody, HttpServletRequest request) {
        try {
            TicketGrantingTicket tgtId = this.createTicketGrantingTicketForRequest(requestBody, request);
            return this.createResponseEntityForTicket(request, tgtId);
        }
        catch (AuthenticationException e) {
            return this.createResponseEntityForAuthnFailure(e);
        }
        catch (BadRequestException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @DeleteMapping(value={"/v1/tickets/{tgtId:.+}"})
    public ResponseEntity<String> deleteTicketGrantingTicket(@PathVariable(value="tgtId") String tgtId) {
        this.centralAuthenticationService.destroyTicketGrantingTicket(tgtId);
        return new ResponseEntity((Object)tgtId, HttpStatus.OK);
    }

    protected ResponseEntity<String> createResponseEntityForTicket(HttpServletRequest request, TicketGrantingTicket tgtId) throws Exception {
        return this.ticketGrantingTicketResourceEntityResponseFactory.build(tgtId, request);
    }

    protected TicketGrantingTicket createTicketGrantingTicketForRequest(MultiValueMap<String, String> requestBody, HttpServletRequest request) {
        Credential credential = this.credentialFactory.fromRequestBody(requestBody);
        Service service = this.serviceFactory.createService(request);
        AuthenticationResult authenticationResult = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction(service, new Credential[]{credential});
        return this.centralAuthenticationService.createTicketGrantingTicket(authenticationResult);
    }

    private ResponseEntity<String> createResponseEntityForAuthnFailure(AuthenticationException e) {
        List authnExceptions = e.getHandlerErrors().values().stream().map(Class::getSimpleName).collect(Collectors.toList());
        HashMap errorsMap = new HashMap();
        errorsMap.put("authentication_exceptions", authnExceptions);
        LOGGER.warn("[{}] Caused by: [{}]", (Object)e.getMessage(), authnExceptions);
        try {
            return new ResponseEntity((Object)this.jacksonPrettyWriter.writeValueAsString(errorsMap), HttpStatus.UNAUTHORIZED);
        }
        catch (JsonProcessingException exception) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

