/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest.factory;

import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.support.rest.factory.ServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.ticket.ServiceTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class DefaultServiceTicketResourceEntityResponseFactory
implements ServiceTicketResourceEntityResponseFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceTicketResourceEntityResponseFactory.class);
    protected final CentralAuthenticationService centralAuthenticationService;

    public DefaultServiceTicketResourceEntityResponseFactory(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    @Override
    public ResponseEntity<String> build(String ticketGrantingTicket, Service service, AuthenticationResult authenticationResult) {
        String serviceTicketId = this.grantServiceTicket(ticketGrantingTicket, service, authenticationResult);
        return new ResponseEntity((Object)serviceTicketId, HttpStatus.OK);
    }

    protected String grantServiceTicket(String ticketGrantingTicket, Service service, AuthenticationResult authenticationResult) {
        ServiceTicket ticket = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicket, service, authenticationResult);
        LOGGER.debug("Generated service ticket [{}]", (Object)ticket.getId());
        return ticket.getId();
    }
}

