/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apereo.cas.DefaultMessageDescriptor;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MessageDescriptor;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.support.password.PasswordExpiringWarningMessageDescriptor;
import org.apereo.cas.configuration.model.support.rest.RestAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class RestAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestAuthenticationHandler.class);
    public static final String HEADER_NAME_CAS_PASSWORD_EXPIRATION_DATE = "X-CAS-PasswordExpirationDate";
    public static final String HEADER_NAME_CAS_WARNING = "X-CAS-Warning";
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private final RestAuthenticationProperties properties;

    public RestAuthenticationHandler(ServicesManager servicesManager, PrincipalFactory principalFactory, RestAuthenticationProperties properties) {
        super(properties.getName(), servicesManager, principalFactory, properties.getOrder());
        this.properties = properties;
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException {
        HttpResponse response = null;
        try {
            HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().basicAuthUsername(credential.getUsername()).basicAuthPassword(credential.getPassword()).method(HttpMethod.POST).url(this.properties.getUri()).build();
            response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
            HttpStatus status = HttpStatus.resolve((int)Objects.requireNonNull(response).getStatusLine().getStatusCode());
            switch (Objects.requireNonNull(status)) {
                case OK: {
                    AuthenticationHandlerExecutionResult authenticationHandlerExecutionResult = this.buildPrincipalFromResponse(credential, response);
                    return authenticationHandlerExecutionResult;
                }
                case FORBIDDEN: {
                    throw new AccountDisabledException("Could not authenticate forbidden account for " + credential.getUsername());
                }
                case UNAUTHORIZED: {
                    throw new FailedLoginException("Could not authenticate account for " + credential.getUsername());
                }
                case NOT_FOUND: {
                    throw new AccountNotFoundException("Could not locate account for " + credential.getUsername());
                }
                case LOCKED: {
                    throw new AccountLockedException("Could not authenticate locked account for " + credential.getUsername());
                }
                case PRECONDITION_FAILED: {
                    throw new AccountExpiredException("Could not authenticate expired account for " + credential.getUsername());
                }
                case PRECONDITION_REQUIRED: {
                    throw new AccountPasswordMustChangeException("Account password must change for " + credential.getUsername());
                }
            }
            throw new FailedLoginException("Rest endpoint returned an unknown status code " + status + " for " + credential.getUsername());
        }
        finally {
            HttpUtils.close((HttpResponse)response);
        }
    }

    protected AuthenticationHandlerExecutionResult buildPrincipalFromResponse(UsernamePasswordCredential credential, HttpResponse response) throws GeneralSecurityException {
        try {
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            LOGGER.debug("REST authentication response received: [{}]", (Object)result);
            Principal principalFromRest = (Principal)MAPPER.readValue(result, Principal.class);
            Principal principal = this.principalFactory.createPrincipal(principalFromRest.getId(), principalFromRest.getAttributes());
            return this.createHandlerResult((Credential)credential, principal, this.getWarnings(response));
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new FailedLoginException("Unable to detect the authentication principal for " + credential.getUsername());
        }
    }

    protected List<MessageDescriptor> getWarnings(HttpResponse authenticationResponse) {
        Header[] warnings;
        ArrayList<MessageDescriptor> messageDescriptors = new ArrayList<MessageDescriptor>(2);
        Header passwordExpirationDate = authenticationResponse.getFirstHeader(HEADER_NAME_CAS_PASSWORD_EXPIRATION_DATE);
        if (passwordExpirationDate != null) {
            long days = Duration.between(Instant.now(Clock.systemUTC()), DateTimeUtils.convertToZonedDateTime((String)passwordExpirationDate.getValue())).toDays();
            messageDescriptors.add((MessageDescriptor)new PasswordExpiringWarningMessageDescriptor(null, days));
        }
        if ((warnings = authenticationResponse.getHeaders(HEADER_NAME_CAS_WARNING)) != null) {
            Arrays.stream(warnings).map(NameValuePair::getValue).map(DefaultMessageDescriptor::new).forEach(messageDescriptors::add);
        }
        return messageDescriptors;
    }
}

