/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.rest.RestAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.support.rest.RestAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration(value="casRestAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasRestAuthenticationConfiguration {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).singleValueAsArray(true).build().toObjectMapper();
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    @Bean
    @RefreshScope
    public RestTemplate restAuthenticationTemplate() {
        RestAuthenticationProperties rest = this.casProperties.getAuthn().getRest();
        RestTemplate template = new RestTemplate();
        template.getMessageConverters().stream().filter(c -> c instanceof MappingJackson2HttpMessageConverter).map(MappingJackson2HttpMessageConverter.class::cast).findFirst().ifPresent(converter -> {
            converter.setPrettyPrint(true);
            converter.setDefaultCharset(Charset.forName(rest.getCharset()));
            converter.setObjectMapper(MAPPER);
        });
        return template;
    }

    @ConditionalOnMissingBean(name={"restAuthenticationPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory restAuthenticationPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @ConditionalOnMissingBean(name={"restAuthenticationHandler"})
    public AuthenticationHandler restAuthenticationHandler() {
        RestAuthenticationProperties rest = this.casProperties.getAuthn().getRest();
        RestAuthenticationHandler r = new RestAuthenticationHandler((ServicesManager)this.servicesManager.getObject(), this.restAuthenticationPrincipalFactory(), rest);
        r.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)rest.getPasswordEncoder(), (ApplicationContext)this.applicationContext));
        r.setState(rest.getState());
        return r;
    }

    @ConditionalOnMissingBean(name={"casRestAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer casRestAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            if (StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getRest().getUri())) {
                plan.registerAuthenticationHandlerWithPrincipalResolver(this.restAuthenticationHandler(), (PrincipalResolver)this.defaultPrincipalResolver.getObject());
            }
        };
    }
}

