/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.radius.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.adaptors.radius.RadiusUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadiusAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RadiusAuthenticationHandler.class);
    private final List<RadiusServer> servers;
    private final boolean failoverOnException;
    private final boolean failoverOnAuthenticationFailure;

    public RadiusAuthenticationHandler(String name, PrincipalFactory principalFactory, List<RadiusServer> servers, boolean failoverOnException, boolean failoverOnAuthenticationFailure) {
        super(name, principalFactory, null);
        this.servers = servers;
        this.failoverOnException = failoverOnException;
        this.failoverOnAuthenticationFailure = failoverOnAuthenticationFailure;
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException {
        try {
            String username = credential.getUsername();
            Pair result = RadiusUtils.authenticate((String)username, (String)credential.toPassword(), this.servers, (boolean)this.failoverOnAuthenticationFailure, (boolean)this.failoverOnException, Optional.empty());
            if (((Boolean)result.getKey()).booleanValue() && ((Optional)result.getValue()).isPresent()) {
                Map attributes = CollectionUtils.toMultiValuedMap((Map)((Map)((Optional)result.getValue()).get()));
                return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username, attributes), new ArrayList());
            }
            throw new FailedLoginException("Radius authentication failed for user " + username);
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new FailedLoginException("Radius authentication failed " + e.getMessage());
        }
    }
}

