/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.radius.web.flow;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.authentication.BaseMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RadiusAccessChallengedAuthenticationWebflowEventResolver
extends BaseMultifactorAuthenticationProviderEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RadiusAccessChallengedAuthenticationWebflowEventResolver.class);
    private final String radiusMultifactorAuthenticationProviderId;

    public RadiusAccessChallengedAuthenticationWebflowEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationSelectionStrategies, MultifactorAuthenticationProviderSelector selector, String providerId) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationSelectionStrategies, selector);
        this.radiusMultifactorAuthenticationProviderId = providerId;
    }

    public Set<Event> resolveInternal(RequestContext context) {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        if (authentication == null) {
            LOGGER.debug("No authentication or service is available to determine event for principal");
            return null;
        }
        Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        if (providerMap == null || providerMap.isEmpty()) {
            LOGGER.error("No multifactor authentication providers are available in the application context");
            throw new AuthenticationException();
        }
        Principal principal = authentication.getPrincipal();
        Map attributes = principal.getAttributes();
        LOGGER.debug("Evaluating principal attributes [{}] for multifactor authentication", attributes.keySet());
        if (attributes.containsKey("Reply-Message") && attributes.containsKey("State")) {
            LOGGER.debug("Authentication requires multifactor authentication via provider [{}]", (Object)this.radiusMultifactorAuthenticationProviderId);
            Optional providerFound = this.resolveProvider(providerMap, this.radiusMultifactorAuthenticationProviderId);
            if (providerFound.isPresent()) {
                MultifactorAuthenticationProvider multifactorAuthenticationProvider = (MultifactorAuthenticationProvider)providerFound.get();
                Event event = this.validateEventIdForMatchingTransitionInContext(multifactorAuthenticationProvider.getId(), context, RadiusAccessChallengedAuthenticationWebflowEventResolver.buildEventAttributeMap((Principal)authentication.getPrincipal(), null, (MultifactorAuthenticationProvider)multifactorAuthenticationProvider));
                return CollectionUtils.wrapSet((Object)event);
            }
            LOGGER.warn("No multifactor provider could be found for [{}]", (Object)this.radiusMultifactorAuthenticationProviderId);
            throw new AuthenticationException();
        }
        return null;
    }

    @Audit(action="AUTHENTICATION_EVENT", actionResolverName="AUTHENTICATION_EVENT_ACTION_RESOLVER", resourceResolverName="AUTHENTICATION_EVENT_RESOURCE_RESOLVER")
    public Event resolveSingle(RequestContext context) {
        return super.resolveSingle(context);
    }
}

