/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.adaptors.radius.JRadiusServerImpl;
import org.apereo.cas.adaptors.radius.RadiusClientFactory;
import org.apereo.cas.adaptors.radius.RadiusProtocol;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.adaptors.radius.authentication.handler.support.RadiusAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusClientProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusServerProperties;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(value="radiusConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RadiusConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RadiusConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired(required=false)
    @Qualifier(value="radiusPasswordPolicyConfiguration")
    private PasswordPolicyConfiguration passwordPolicyConfiguration;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @ConditionalOnMissingBean(name={"radiusPrincipalFactory"})
    @Bean
    public PrincipalFactory radiusPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @RefreshScope
    @Bean
    public JRadiusServerImpl radiusServer() {
        RadiusClientProperties client = this.casProperties.getAuthn().getRadius().getClient();
        RadiusServerProperties server = this.casProperties.getAuthn().getRadius().getServer();
        Set<String> ips = RadiusConfiguration.getClientIps(client);
        return this.getSingleRadiusServer(client, server, ips.iterator().next());
    }

    public static Set<String> getClientIps(RadiusClientProperties client) {
        return StringUtils.commaDelimitedListToSet((String)StringUtils.trimAllWhitespace((String)client.getInetAddress()));
    }

    private JRadiusServerImpl getSingleRadiusServer(RadiusClientProperties client, RadiusServerProperties server, String clientInetAddress) {
        RadiusClientFactory factory = new RadiusClientFactory(client.getAccountingPort(), client.getAuthenticationPort(), client.getSocketTimeout(), clientInetAddress, client.getSharedSecret());
        RadiusProtocol protocol = RadiusProtocol.valueOf((String)server.getProtocol());
        return new JRadiusServerImpl(protocol, factory, server.getRetries(), server.getNasIpAddress(), server.getNasIpv6Address(), server.getNasPort(), server.getNasPortId(), server.getNasIdentifier(), server.getNasRealPort());
    }

    @RefreshScope
    @Bean
    public List<RadiusServer> radiusServers() {
        RadiusClientProperties client = this.casProperties.getAuthn().getRadius().getClient();
        RadiusServerProperties server = this.casProperties.getAuthn().getRadius().getServer();
        Set<String> ips = RadiusConfiguration.getClientIps(this.casProperties.getAuthn().getRadius().getClient());
        return ips.stream().map(ip -> this.getSingleRadiusServer(client, server, (String)ip)).collect(Collectors.toList());
    }

    @Bean
    public AuthenticationHandler radiusAuthenticationHandler() {
        RadiusProperties radius = this.casProperties.getAuthn().getRadius();
        RadiusAuthenticationHandler h = new RadiusAuthenticationHandler(radius.getName(), this.servicesManager, this.radiusPrincipalFactory(), this.radiusServers(), radius.isFailoverOnException(), radius.isFailoverOnAuthenticationFailure());
        h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)radius.getPasswordEncoder()));
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)radius.getPrincipalTransformation()));
        if (this.passwordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.passwordPolicyConfiguration);
        }
        return h;
    }

    @ConditionalOnMissingBean(name={"radiusAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer radiusAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            Set<String> ips = RadiusConfiguration.getClientIps(this.casProperties.getAuthn().getRadius().getClient());
            if (!ips.isEmpty()) {
                plan.registerAuthenticationHandler(this.radiusAuthenticationHandler());
            } else {
                LOGGER.warn("No RADIUS address is defined. RADIUS support will be disabled.");
            }
        };
    }
}

