/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.radius.JRadiusServerImpl;
import org.apereo.cas.adaptors.radius.RadiusClientFactory;
import org.apereo.cas.adaptors.radius.RadiusProtocol;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.adaptors.radius.authentication.handler.support.RadiusAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="radiusConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RadiusConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RadiusConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired(required=false)
    @Qualifier(value="radiusPasswordPolicyConfiguration")
    private PasswordPolicyConfiguration passwordPolicyConfiguration;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @ConditionalOnMissingBean(name={"radiusPrincipalFactory"})
    @Bean
    public PrincipalFactory radiusPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @RefreshScope
    @Bean
    public JRadiusServerImpl radiusServer() {
        RadiusProperties.Client client = this.casProperties.getAuthn().getRadius().getClient();
        RadiusProperties.Server server = this.casProperties.getAuthn().getRadius().getServer();
        RadiusClientFactory factory = new RadiusClientFactory(client.getAccountingPort(), client.getAuthenticationPort(), client.getSocketTimeout(), client.getInetAddress(), client.getSharedSecret());
        RadiusProtocol protocol = RadiusProtocol.valueOf((String)server.getProtocol());
        return new JRadiusServerImpl(protocol, factory, server.getRetries(), server.getNasIpAddress(), server.getNasIpv6Address(), server.getNasPort(), server.getNasPortId(), server.getNasIdentifier(), server.getNasRealPort());
    }

    @RefreshScope
    @Bean
    public List<RadiusServer> radiusServers() {
        ArrayList<RadiusServer> list = new ArrayList<RadiusServer>();
        list.add((RadiusServer)this.radiusServer());
        return list;
    }

    @Bean
    public AuthenticationHandler radiusAuthenticationHandler() {
        RadiusProperties radius = this.casProperties.getAuthn().getRadius();
        RadiusAuthenticationHandler h = new RadiusAuthenticationHandler(radius.getName(), this.servicesManager, this.radiusPrincipalFactory(), this.radiusServers(), radius.isFailoverOnException(), radius.isFailoverOnAuthenticationFailure());
        h.setPasswordEncoder(Beans.newPasswordEncoder((PasswordEncoderProperties)radius.getPasswordEncoder()));
        h.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)radius.getPrincipalTransformation()));
        if (this.passwordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.passwordPolicyConfiguration);
        }
        return h;
    }

    @Configuration(value="radiusAuthenticationEventExecutionPlanConfiguration")
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public class RadiusAuthenticationEventExecutionPlanConfiguration
    implements AuthenticationEventExecutionPlanConfigurer {
        public void configureAuthenticationExecutionPlan(AuthenticationEventExecutionPlan plan) {
            if (StringUtils.isNotBlank((CharSequence)RadiusConfiguration.this.casProperties.getAuthn().getRadius().getClient().getInetAddress())) {
                plan.registerAuthenticationHandler(RadiusConfiguration.this.radiusAuthenticationHandler());
            } else {
                LOGGER.warn("No RADIUS address is defined. RADIUS support will be disabled.");
            }
        }
    }
}

