/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apereo.cas.adaptors.radius.JRadiusServerImpl;
import org.apereo.cas.adaptors.radius.RadiusClientFactory;
import org.apereo.cas.adaptors.radius.RadiusProtocol;
import org.apereo.cas.adaptors.radius.authentication.handler.support.RadiusAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.support.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="radiusConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RadiusConfiguration {
    @Autowired
    @Qualifier(value="authenticationHandlersResolvers")
    private Map authenticationHandlersResolvers;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired(required=false)
    @Qualifier(value="radiusPasswordPolicyConfiguration")
    private PasswordPolicyConfiguration passwordPolicyConfiguration;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @Bean
    public PrincipalFactory radiusPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @RefreshScope
    @Bean
    public JRadiusServerImpl radiusServer() {
        RadiusClientFactory factory = new RadiusClientFactory();
        factory.setAccountingPort(this.casProperties.getAuthn().getRadius().getClient().getAccountingPort());
        factory.setAuthenticationPort(this.casProperties.getAuthn().getRadius().getClient().getAuthenticationPort());
        factory.setInetAddress(this.casProperties.getAuthn().getRadius().getClient().getInetAddress());
        factory.setSharedSecret(this.casProperties.getAuthn().getRadius().getClient().getSharedSecret());
        factory.setSocketTimeout(this.casProperties.getAuthn().getRadius().getClient().getSocketTimeout());
        RadiusProtocol protocol = RadiusProtocol.valueOf((String)this.casProperties.getAuthn().getRadius().getServer().getProtocol());
        JRadiusServerImpl impl = new JRadiusServerImpl(protocol, factory);
        impl.setRetries(this.casProperties.getAuthn().getRadius().getServer().getRetries());
        impl.setNasIdentifier(this.casProperties.getAuthn().getRadius().getServer().getNasIdentifier());
        impl.setNasPort(this.casProperties.getAuthn().getRadius().getServer().getNasPort());
        impl.setNasPortId(this.casProperties.getAuthn().getRadius().getServer().getNasPortId());
        impl.setNasRealPort(this.casProperties.getAuthn().getRadius().getServer().getNasRealPort());
        impl.setNasIpAddress(this.casProperties.getAuthn().getRadius().getServer().getNasIpAddress());
        impl.setNasIpv6Address(this.casProperties.getAuthn().getRadius().getServer().getNasIpv6Address());
        return impl;
    }

    @RefreshScope
    @Bean
    public List radiusServers() {
        ArrayList<JRadiusServerImpl> list = new ArrayList<JRadiusServerImpl>();
        list.add(this.radiusServer());
        return list;
    }

    @Bean
    public AuthenticationHandler radiusAuthenticationHandler() {
        RadiusAuthenticationHandler h = new RadiusAuthenticationHandler();
        h.setFailoverOnAuthenticationFailure(this.casProperties.getAuthn().getRadius().isFailoverOnAuthenticationFailure());
        h.setFailoverOnException(this.casProperties.getAuthn().getRadius().isFailoverOnException());
        h.setServers(this.radiusServers());
        h.setPasswordEncoder(Beans.newPasswordEncoder((PasswordEncoderProperties)this.casProperties.getAuthn().getRadius().getPasswordEncoder()));
        h.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)this.casProperties.getAuthn().getRadius().getPrincipalTransformation()));
        if (this.passwordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.passwordPolicyConfiguration);
        }
        h.setPrincipalFactory(this.radiusPrincipalFactory());
        h.setServicesManager(this.servicesManager);
        return h;
    }

    @PostConstruct
    protected void initializeRootApplicationContext() {
        this.authenticationHandlersResolvers.put(this.radiusAuthenticationHandler(), null);
    }
}

