/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SendPasswordResetInstructionsAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SendPasswordResetInstructionsAction.class);
    public static final String REQUEST_PARAMETER_USERNAME = "username";
    protected final CasConfigurationProperties casProperties;
    protected final CommunicationsManager communicationsManager;
    protected final PasswordManagementService passwordManagementService;
    protected final TicketRegistry ticketRegistry;
    protected final TicketFactory ticketFactory;
    protected final PrincipalResolver principalResolver;

    protected String buildPasswordResetUrl(String username, PasswordManagementService passwordManagementService, CasConfigurationProperties casProperties, WebApplicationService service) throws Exception {
        PasswordManagementQuery query = PasswordManagementQuery.builder().username(username).build();
        String token = passwordManagementService.createToken(query);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
            PasswordManagementProperties pm = casProperties.getAuthn().getPm();
            long seconds = Beans.newDuration((String)pm.getReset().getExpiration()).toSeconds();
            Map properties = CollectionUtils.wrap((String)"token", (Object)token, (String)ExpirationPolicy.class.getName(), (Object)HardTimeoutExpirationPolicy.builder().timeToKillInSeconds(seconds).build());
            TransientSessionTicket ticket = transientFactory.create((Service)service, properties);
            this.ticketRegistry.addTicket((Ticket)ticket);
            StringBuilder resetUrl = new StringBuilder(casProperties.getServer().getPrefix()).append('/').append("login").append('?').append("pswdrst").append('=').append(ticket.getId());
            if (service != null) {
                String encodeServiceUrl = UriUtils.encode((String)service.getOriginalUrl(), (Charset)StandardCharsets.UTF_8);
                resetUrl.append('&').append("service").append('=').append(encodeServiceUrl);
            }
            String url = resetUrl.toString();
            LOGGER.debug("Final password reset URL designed for [{}] is [{}]", (Object)username, (Object)url);
            return url;
        }
        LOGGER.error("Could not create password reset url since no reset token could be generated");
        return null;
    }

    @Audit(action="REQUEST_CHANGE_PASSWORD", principalResolverName="REQUEST_CHANGE_PASSWORD_PRINCIPAL_RESOLVER", actionResolverName="REQUEST_CHANGE_PASSWORD_ACTION_RESOLVER", resourceResolverName="REQUEST_CHANGE_PASSWORD_RESOURCE_RESOLVER")
    protected Event doExecute(RequestContext requestContext) throws Exception {
        this.communicationsManager.validate();
        if (!this.communicationsManager.isMailSenderDefined() && !this.communicationsManager.isSmsSenderDefined()) {
            return this.getErrorEvent("contact.failed", "Unable to send email as no mail sender is defined", requestContext);
        }
        PasswordManagementQuery query = this.buildPasswordManagementQuery(requestContext);
        if (StringUtils.isBlank((CharSequence)query.getUsername())) {
            return this.getErrorEvent("username.required", "No username is provided", requestContext);
        }
        String email = this.passwordManagementService.findEmail(query);
        String phone = this.passwordManagementService.findPhone(query);
        if (StringUtils.isBlank((CharSequence)email) && StringUtils.isBlank((CharSequence)phone)) {
            LOGGER.warn("No recipient is provided with a valid email/phone");
            return this.getErrorEvent("contact.invalid", "Provided email address or phone number is invalid", requestContext);
        }
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        String url = this.buildPasswordResetUrl(query.getUsername(), this.passwordManagementService, this.casProperties, service);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
            Duration duration = Beans.newDuration((String)pm.getReset().getExpiration());
            LOGGER.debug("Generated password reset URL [{}]; Link is only active for the next [{}] minute(s)", (Object)url, (Object)duration);
            boolean sendEmail = this.sendPasswordResetEmailToAccount(query.getUsername(), email, url, requestContext);
            boolean sendSms = this.sendPasswordResetSmsToAccount(phone, url);
            if (sendEmail || sendSms) {
                return this.success(url);
            }
        } else {
            LOGGER.error("No password reset URL could be built and sent to [{}]", (Object)email);
        }
        LOGGER.error("Failed to notify account [{}]", (Object)email);
        return this.getErrorEvent("contact.failed", "Failed to send the password reset link via email address or phone", requestContext);
    }

    protected PasswordManagementQuery buildPasswordManagementQuery(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String username = request.getParameter(REQUEST_PARAMETER_USERNAME);
        PasswordManagementQuery.PasswordManagementQueryBuilder builder = PasswordManagementQuery.builder();
        if (StringUtils.isBlank((CharSequence)username)) {
            LOGGER.warn("No username parameter is provided");
        }
        return builder.username(username).build();
    }

    protected boolean sendPasswordResetSmsToAccount(String to, String url) {
        if (StringUtils.isNotBlank((CharSequence)to)) {
            LOGGER.debug("Sending password reset URL [{}] via SMS to [{}]", (Object)url, (Object)to);
            SmsProperties reset = this.casProperties.getAuthn().getPm().getReset().getSms();
            String message = reset.getFormattedText(new Object[]{url});
            return this.communicationsManager.sms(reset.getFrom(), to, message);
        }
        return false;
    }

    protected boolean sendPasswordResetEmailToAccount(String username, String to, String url, RequestContext requestContext) {
        if (StringUtils.isNotBlank((CharSequence)to)) {
            EmailProperties reset = this.casProperties.getAuthn().getPm().getReset().getMail();
            Map parameters = CollectionUtils.wrap((String)"url", (Object)url);
            BasicIdentifiableCredential credential = new BasicIdentifiableCredential();
            credential.setId(username);
            Principal person = this.principalResolver.resolve((Credential)credential);
            FunctionUtils.doIfNotNull((Object)person, principal -> parameters.put("principal", principal));
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            String text = EmailMessageBodyBuilder.builder().properties(reset).parameters(parameters).locale(Optional.ofNullable(request.getLocale())).build().produce();
            LOGGER.debug("Sending password reset URL [{}] via email to [{}] for username [{}]", new Object[]{url, to, username});
            return this.communicationsManager.email(reset, to, text);
        }
        return false;
    }

    protected Event getErrorEvent(String code, String defaultMessage, RequestContext requestContext) {
        WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)("screen.pm.reset." + code), (String)defaultMessage);
        LOGGER.error(defaultMessage);
        return new EventFactorySupport().event((Object)this, "error");
    }

    @Generated
    public SendPasswordResetInstructionsAction(CasConfigurationProperties casProperties, CommunicationsManager communicationsManager, PasswordManagementService passwordManagementService, TicketRegistry ticketRegistry, TicketFactory ticketFactory, PrincipalResolver principalResolver) {
        this.casProperties = casProperties;
        this.communicationsManager = communicationsManager;
        this.passwordManagementService = passwordManagementService;
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
        this.principalResolver = principalResolver;
    }
}

