/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.BaseSingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordManagementSingleSignOnParticipationStrategy
extends BaseSingleSignOnParticipationStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordManagementSingleSignOnParticipationStrategy.class);
    private final CentralAuthenticationService centralAuthenticationService;

    public PasswordManagementSingleSignOnParticipationStrategy(ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, AuthenticationServiceSelectionPlan serviceSelectionStrategy, CentralAuthenticationService centralAuthenticationService) {
        super(servicesManager, ticketRegistrySupport, serviceSelectionStrategy);
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public boolean isParticipating(SingleSignOnParticipationRequest ssoRequest) {
        Optional token = ssoRequest.getRequestParameter("pswdrst");
        try {
            if (token.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)token.get()))) {
                TransientSessionTicket ticket = (TransientSessionTicket)this.centralAuthenticationService.getTicket((String)token.get(), TransientSessionTicket.class);
                LOGGER.trace("Token ticket [{}] is valid. SSO will be disabled to allow password-resets", (Object)ticket);
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.trace("Token ticket [{}] is not found or has expired. SSO will not be disabled", (Object)token);
        }
        return true;
    }

    public boolean supports(SingleSignOnParticipationRequest ssoRequest) {
        Optional token = ssoRequest.getRequestParameter("pswdrst");
        return token.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)token.get()));
    }
}

