/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.config;

import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.web.flow.ForgotUsernameCaptchaWebflowConfigurer;
import org.apereo.cas.pm.web.flow.ForgotUsernameWebflowConfigurer;
import org.apereo.cas.pm.web.flow.actions.SendForgotUsernameInstructionsAction;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.CaptchaActivationStrategy;
import org.apereo.cas.web.CaptchaValidator;
import org.apereo.cas.web.DefaultCaptchaActivationStrategy;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.InitializeCaptchaAction;
import org.apereo.cas.web.flow.ValidateCaptchaAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.SpringWebflowActionExecutionAuditablePrincipalResolver;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;

@Configuration(value="PasswordManagementForgotUsernameConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(prefix="cas.authn.pm.forgot-username", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class PasswordManagementForgotUsernameConfiguration {

    @ConditionalOnProperty(prefix="cas.authn.pm.forgot-username.google-recaptcha", name={"enabled"}, havingValue="true")
    @Configuration(value="ForgotUsernameCaptchaConfiguration", proxyBeanMethods=false)
    public static class ForgotUsernameCaptchaConfiguration {
        @ConditionalOnMissingBean(name={"forgotUsernameCaptchaWebflowConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public CasWebflowConfigurer forgotUsernameCaptchaWebflowConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            ForgotUsernameCaptchaWebflowConfigurer configurer = new ForgotUsernameCaptchaWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
            configurer.setOrder(casProperties.getAuthn().getPm().getWebflow().getOrder() + 2);
            return configurer;
        }

        @ConditionalOnMissingBean(name={"forgotUsernameValidateCaptchaAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public Action forgotUsernameValidateCaptchaAction(CasConfigurationProperties casProperties, @Qualifier(value="forgotUsernameCaptchaActivationStrategy") CaptchaActivationStrategy forgotUsernameCaptchaActivationStrategy) {
            GoogleRecaptchaProperties recaptcha = casProperties.getAuthn().getPm().getForgotUsername().getGoogleRecaptcha();
            return new ValidateCaptchaAction(CaptchaValidator.getInstance((GoogleRecaptchaProperties)recaptcha), forgotUsernameCaptchaActivationStrategy);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"forgotUsernameInitializeCaptchaAction"})
        public Action forgotUsernameInitializeCaptchaAction(@Qualifier(value="forgotUsernameCaptchaActivationStrategy") CaptchaActivationStrategy forgotUsernameCaptchaActivationStrategy, CasConfigurationProperties casProperties) {
            GoogleRecaptchaProperties recaptcha = casProperties.getAuthn().getPm().getForgotUsername().getGoogleRecaptcha();
            return new InitializeCaptchaAction(forgotUsernameCaptchaActivationStrategy, requestContext -> WebUtils.putRecaptchaForgotUsernameEnabled((RequestContext)requestContext, (GoogleRecaptchaProperties)recaptcha), recaptcha);
        }

        @Bean
        @ConditionalOnMissingBean(name={"forgotUsernameCaptchaActivationStrategy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CaptchaActivationStrategy forgotUsernameCaptchaActivationStrategy(@Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DefaultCaptchaActivationStrategy(servicesManager);
        }

        @Bean
        @ConditionalOnMissingBean(name={"forgotUsernameCaptchaWebflowExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer forgotUsernameCaptchaWebflowExecutionPlanConfigurer(@Qualifier(value="forgotUsernameCaptchaWebflowConfigurer") CasWebflowConfigurer cfg) {
            return plan -> plan.registerWebflowConfigurer(cfg);
        }
    }

    @Configuration(value="PasswordManagementForgotUsernameWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementForgotUsernameWebflowConfiguration {
        @ConditionalOnMissingBean(name={"sendForgotUsernameInstructionsAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action sendForgotUsernameInstructionsAction(CasConfigurationProperties casProperties, @Qualifier(value="communicationsManager") CommunicationsManager communicationsManager, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
            return new SendForgotUsernameInstructionsAction(casProperties, communicationsManager, passwordManagementService, defaultPrincipalResolver);
        }

        @ConditionalOnMissingBean(name={"forgotUsernameWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer forgotUsernameWebflowConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return new ForgotUsernameWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"forgotUsernameCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer forgotUsernameCasWebflowExecutionPlanConfigurer(@Qualifier(value="forgotUsernameWebflowConfigurer") CasWebflowConfigurer forgotUsernameWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(forgotUsernameWebflowConfigurer);
        }
    }

    @Configuration(value="PasswordManagementForgotUsernameAuditConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementForgotUsernameAuditConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"forgotUsernameAuditTrailRecordResolutionPlanConfigurer"})
        public AuditTrailRecordResolutionPlanConfigurer forgotUsernameAuditTrailRecordResolutionPlanConfigurer(@Qualifier(value="returnValueResourceResolver") AuditResourceResolver returnValueResourceResolver) {
            return plan -> {
                plan.registerAuditActionResolver("REQUEST_FORGOT_USERNAME_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver());
                plan.registerAuditResourceResolver("REQUEST_FORGOT_USERNAME_RESOURCE_RESOLVER", returnValueResourceResolver);
                plan.registerAuditPrincipalResolver("REQUEST_FORGOT_USERNAME_PRINCIPAL_RESOLVER", (org.apereo.inspektr.common.spi.PrincipalResolver)new SpringWebflowActionExecutionAuditablePrincipalResolver("email"));
            };
        }
    }
}

