/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ValidatePasswordResetTokenAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidatePasswordResetTokenAction.class);
    private final PasswordManagementService passwordManagementService;
    private final CentralAuthenticationService centralAuthenticationService;

    protected Event doExecute(RequestContext requestContext) {
        try {
            TransientSessionTicket tst;
            String token;
            String username;
            String transientTicket = requestContext.getRequestParameters().get("pswdrst");
            if (StringUtils.isNotBlank((CharSequence)transientTicket) && StringUtils.isBlank((CharSequence)(username = this.passwordManagementService.parseToken(token = (tst = (TransientSessionTicket)this.centralAuthenticationService.getTicket(transientTicket, TransientSessionTicket.class)).getProperties().get("token").toString())))) {
                throw new IllegalArgumentException("Password reset token could not be verified to determine username");
            }
            return null;
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            return new EventFactorySupport().event((Object)this, "invalidPasswordResetToken");
        }
    }

    @Generated
    public ValidatePasswordResetTokenAction(PasswordManagementService passwordManagementService, CentralAuthenticationService centralAuthenticationService) {
        this.passwordManagementService = passwordManagementService;
        this.centralAuthenticationService = centralAuthenticationService;
    }
}

