/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import java.util.Map;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.actions.StaticEventExecutionAction;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.SubflowState;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;

public class PasswordManagementWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public static final String FLOW_ID_PASSWORD_RESET = "pswdreset";
    public static final String FLOW_VAR_ID_PASSWORD = "password";
    public static final String DO_CHANGE_PASSWORD_PARAMETER = "doChangePassword";

    public PasswordManagementWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(casProperties.getAuthn().getPm().getWebflow().getOrder());
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createAccountStatusViewStates(flow);
        }
    }

    private void createAccountStatusViewStates(Flow flow) {
        this.enablePasswordManagementForFlow(flow);
        this.createViewState(flow, "casAuthenticationBlockedView", "login-error/casAuthenticationBlockedView");
        this.createViewState(flow, "casBadWorkstationView", "login-error/casBadWorkstationView");
        this.createViewState(flow, "casBadHoursView", "login-error/casBadHoursView");
        this.createViewState(flow, "casAccountLockedView", "login-error/casAccountLockedView");
        this.createViewState(flow, "casAccountDisabledView", "login-error/casAccountDisabledView");
        this.createViewState(flow, "casPasswordUpdateSuccess", "password-reset/casPasswordUpdateSuccessView");
        if (this.casProperties.getAuthn().getPm().getCore().isEnabled()) {
            this.configurePasswordResetFlow(flow, "casExpiredPassView", "login-error/casExpiredPassView");
            this.configurePasswordResetFlow(flow, "casMustChangePassView", "login-error/casMustChangePassView");
            this.configurePasswordMustChangeForAuthnWarnings(flow);
            this.configurePasswordExpirationWarning(flow);
            this.createPasswordResetFlow();
            ActionState startState = (ActionState)flow.getStartState();
            this.prependActionsToActionStateExecutionList(flow, startState.getId(), new String[]{"validatePasswordResetTokenAction"});
            this.createTransitionForState((TransitionableState)startState, "invalidPasswordResetToken", "passwordResetErrorView");
            this.createViewState(flow, "passwordResetErrorView", "password-reset/casResetPasswordErrorView");
        } else {
            ViewState expiredState = this.createViewState(flow, "casExpiredPassView", "login-error/casExpiredPassView");
            expiredState.getEntryActionList().add((Action)this.createEvaluateAction("initPasswordChangeAction"));
            ViewState mustChangeState = this.createViewState(flow, "casMustChangePassView", "login-error/casMustChangePassView");
            mustChangeState.getEntryActionList().add((Action)this.createEvaluateAction("initPasswordChangeAction"));
        }
    }

    private void configurePasswordExpirationWarning(Flow flow) {
        TransitionableState warningState = this.getTransitionableState(flow, "showAuthenticationWarningMessages");
        warningState.getEntryActionList().add((Action)this.createEvaluateAction("handlePasswordExpirationWarningMessagesAction"));
    }

    private void configurePasswordMustChangeForAuthnWarnings(Flow flow) {
        TransitionableState warningState = this.getTransitionableState(flow, "showAuthenticationWarningMessages");
        warningState.getEntryActionList().add((Action)this.createEvaluateAction("flowScope.pswdChangePostLogin=true"));
        this.createTransitionForState(warningState, "changePassword", "casMustChangePassView");
    }

    private void createPasswordResetFlow() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            boolean autoLogin = this.casProperties.getAuthn().getPm().getCore().isAutoLogin();
            ViewState state = (ViewState)this.getState(flow, "viewLoginForm", ViewState.class);
            this.createTransitionForState((TransitionableState)state, "resetPassword", "casResetPasswordSendInstructionsView");
            ViewState viewState = this.createViewState(flow, "casResetPasswordSendInstructionsView", "password-reset/casResetPasswordSendInstructionsView");
            this.createTransitionForState((TransitionableState)viewState, "findAccount", "sendPasswordResetInstructions");
            ActionState sendInst = this.createActionState(flow, "sendPasswordResetInstructions", "sendPasswordResetInstructionsAction");
            this.createTransitionForState((TransitionableState)sendInst, "success", "casResetPasswordSentInstructionsView");
            this.createTransitionForState((TransitionableState)sendInst, "error", viewState.getId());
            this.createViewState(flow, "casResetPasswordSentInstructionsView", "password-reset/casResetPasswordSentInstructionsView");
            this.registerPasswordResetFlowDefinition();
            ActionState initializeLoginFormState = (ActionState)this.getState(flow, "initializeLoginForm", ActionState.class);
            String originalTargetState = initializeLoginFormState.getTransition("success").getTargetStateId();
            SubflowState pswdResetSubFlowState = this.createSubflowState(flow, "pswdResetSubflow", FLOW_ID_PASSWORD_RESET);
            TransitionableState createTgt = this.getTransitionableState(flow, "createTicketGrantingTicket");
            createTgt.getEntryActionList().add((Action)this.createEvaluateAction(String.join((CharSequence)DO_CHANGE_PASSWORD_PARAMETER, "flowScope.", " = requestParameters.", " != null")));
            this.createDecisionState(flow, "checkForPswdResetToken", "requestParameters.pswdrst != null", "pswdResetSubflow", originalTargetState);
            this.createTransitionForState((TransitionableState)initializeLoginFormState, "success", "checkForPswdResetToken", true);
            ActionState redirect = this.createActionState(flow, "redirectToLogin", StaticEventExecutionAction.SUCCESS);
            this.createStateDefaultTransition((TransitionableState)redirect, flow.getStartState().getId());
            this.createTransitionForState((TransitionableState)pswdResetSubFlowState, "pswdResetComplete", autoLogin ? "realSubmit" : "redirectToLogin");
            this.createDecisionState(flow, "checkDoChangePassword", "flowScope.doChangePassword == true", "casMustChangePassView", createTgt.getTransition("success").getTargetStateId()).getEntryActionList().add((Action)this.createEvaluateAction("flowScope.pswdChangePostLogin=true"));
            this.createTransitionForState(createTgt, "success", "checkDoChangePassword", true);
            this.createDecisionState(flow, "postLoginPswdChangeCheck", "flowScope.pswdChangePostLogin == true", this.getTransitionableState(flow, "showAuthenticationWarningMessages").getTransition("proceed").getTargetStateId(), autoLogin ? "realSubmit" : "redirectToLogin");
            this.createTransitionForState(this.getTransitionableState(flow, "casPasswordUpdateSuccess"), "proceed", "postLoginPswdChangeCheck");
        }
    }

    private void registerPasswordResetFlowDefinition() {
        Flow pswdFlow = this.buildFlow(FLOW_ID_PASSWORD_RESET);
        pswdFlow.getStartActionList().add((Action)this.createEvaluateAction("initialFlowSetupAction"));
        ActionState initReset = this.createActionState(pswdFlow, "initPasswordReset", "initPasswordResetAction");
        this.createStateDefaultTransition((TransitionableState)initReset, "casMustChangePassView");
        ActionState verifyQuestions = this.createActionState(pswdFlow, "verifySecurityQuestions", "verifySecurityQuestionsAction");
        this.createTransitionForState((TransitionableState)verifyQuestions, "success", "initPasswordReset");
        this.createTransitionForState((TransitionableState)verifyQuestions, "error", "passwordResetErrorView");
        ActionState verifyRequest = this.createActionState(pswdFlow, "verifyPasswordResetRequest", "verifyPasswordResetRequestAction");
        this.createTransitionForState((TransitionableState)verifyRequest, "success", "getSecurityQuestionsView");
        this.createTransitionForState((TransitionableState)verifyRequest, "error", "passwordResetErrorView");
        this.createTransitionForState((TransitionableState)verifyRequest, "questionsDisabled", "initPasswordReset");
        ViewState questionsView = this.createViewState(pswdFlow, "getSecurityQuestionsView", "password-reset/casResetPasswordVerifyQuestionsView");
        this.createTransitionForState((TransitionableState)questionsView, "submit", "verifySecurityQuestions", Map.of("bind", Boolean.FALSE, "validate", Boolean.FALSE));
        this.enablePasswordManagementForFlow(pswdFlow);
        this.createViewState(pswdFlow, "passwordResetErrorView", "password-reset/casResetPasswordErrorView");
        this.createViewState(pswdFlow, "casPasswordUpdateSuccess", "password-reset/casPasswordUpdateSuccessView");
        this.configurePasswordResetFlow(pswdFlow, "casMustChangePassView", "login-error/casMustChangePassView");
        pswdFlow.setStartState((State)verifyRequest);
        this.mainFlowDefinitionRegistry.registerFlowDefinition((FlowDefinition)pswdFlow);
        this.createEndState(pswdFlow, "pswdResetComplete");
        this.createTransitionForState(this.getTransitionableState(pswdFlow, "casPasswordUpdateSuccess"), "proceed", "pswdResetComplete");
    }

    private void enablePasswordManagementForFlow(Flow flow) {
        flow.getStartActionList().add((Action)new ConsumerExecutionAction(context -> WebUtils.putPasswordManagementEnabled((RequestContext)context, (Boolean)this.casProperties.getAuthn().getPm().getCore().isEnabled())));
    }

    private void configurePasswordResetFlow(Flow flow, String id, String viewId) {
        this.createFlowVariable(flow, FLOW_VAR_ID_PASSWORD, PasswordChangeRequest.class);
        BinderConfiguration binder = this.createStateBinderConfiguration(CollectionUtils.wrapList((Object[])new String[]{FLOW_VAR_ID_PASSWORD, "confirmedPassword"}));
        ViewState viewState = this.createViewState(flow, id, viewId, binder);
        this.createStateModelBinding((TransitionableState)viewState, FLOW_VAR_ID_PASSWORD, PasswordChangeRequest.class);
        viewState.getEntryActionList().add((Action)this.createEvaluateAction("initPasswordChangeAction"));
        this.createTransitionForState((TransitionableState)viewState, "submit", "passwordChangeAction", Map.of("bind", Boolean.TRUE, "validate", Boolean.TRUE));
        this.createStateDefaultTransition((TransitionableState)viewState, id);
        ActionState pswChangeAction = this.createActionState(flow, "passwordChangeAction", (Action)this.createEvaluateAction("passwordChangeAction"));
        TransitionSet transitionSet = pswChangeAction.getTransitionSet();
        transitionSet.add(this.createTransition("passwordUpdateSuccess", "casPasswordUpdateSuccess"));
        transitionSet.add(this.createTransition("error", id));
    }
}

