/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.config;

import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.web.flow.ForgotUsernameCaptchaWebflowConfigurer;
import org.apereo.cas.pm.web.flow.ForgotUsernameWebflowConfigurer;
import org.apereo.cas.pm.web.flow.actions.SendForgotUsernameInstructionsAction;
import org.apereo.cas.web.CaptchaValidator;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.InitializeCaptchaAction;
import org.apereo.cas.web.flow.ValidateCaptchaAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.SpringWebflowActionExecutionAuditablePrincipalResolver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Configuration(value="PasswordManagementForgotUsernameConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class PasswordManagementForgotUsernameConfiguration {
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="returnValueResourceResolver")
    private ObjectProvider<AuditResourceResolver> returnValueResourceResolver;
    @Autowired
    @Qualifier(value="communicationsManager")
    private ObjectProvider<CommunicationsManager> communicationsManager;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="passwordChangeService")
    private ObjectProvider<PasswordManagementService> passwordManagementService;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;

    @ConditionalOnMissingBean(name={"sendForgotUsernameInstructionsAction"})
    @Bean
    @RefreshScope
    public Action sendForgotUsernameInstructionsAction() {
        return new SendForgotUsernameInstructionsAction(this.casProperties, (CommunicationsManager)this.communicationsManager.getObject(), (PasswordManagementService)this.passwordManagementService.getObject(), (PrincipalResolver)this.defaultPrincipalResolver.getObject());
    }

    @ConditionalOnMissingBean(name={"forgotUsernameWebflowConfigurer"})
    @RefreshScope
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer forgotUsernameWebflowConfigurer() {
        return new ForgotUsernameWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.applicationContext, this.casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"forgotUsernameAuditTrailRecordResolutionPlanConfigurer"})
    public AuditTrailRecordResolutionPlanConfigurer forgotUsernameAuditTrailRecordResolutionPlanConfigurer() {
        return plan -> {
            plan.registerAuditActionResolver("REQUEST_FORGOT_USERNAME_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver());
            plan.registerAuditResourceResolver("REQUEST_FORGOT_USERNAME_RESOURCE_RESOLVER", (AuditResourceResolver)this.returnValueResourceResolver.getObject());
            plan.registerAuditPrincipalResolver("REQUEST_FORGOT_USERNAME_PRINCIPAL_RESOLVER", (org.apereo.inspektr.common.spi.PrincipalResolver)new SpringWebflowActionExecutionAuditablePrincipalResolver("email"));
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"forgotUsernameCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer forgotUsernameCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.forgotUsernameWebflowConfigurer());
    }

    @ConditionalOnProperty(prefix="cas.authn.pm.forgot-username.google-recaptcha", name={"enabled"}, havingValue="true")
    @Configuration(value="forgotUsernameCaptchaConfiguration", proxyBeanMethods=false)
    @DependsOn(value={"passwordManagementWebflowConfigurer"})
    public class ForgotUsernameCaptchaConfiguration {
        @ConditionalOnMissingBean(name={"forgotUsernameCaptchaWebflowConfigurer"})
        @RefreshScope
        @Bean
        public CasWebflowConfigurer forgotUsernameCaptchaWebflowConfigurer() {
            ForgotUsernameCaptchaWebflowConfigurer configurer = new ForgotUsernameCaptchaWebflowConfigurer((FlowBuilderServices)PasswordManagementForgotUsernameConfiguration.this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)PasswordManagementForgotUsernameConfiguration.this.loginFlowDefinitionRegistry.getObject(), PasswordManagementForgotUsernameConfiguration.this.applicationContext, PasswordManagementForgotUsernameConfiguration.this.casProperties);
            configurer.setOrder(PasswordManagementForgotUsernameConfiguration.this.casProperties.getAuthn().getPm().getWebflow().getOrder() + 2);
            return configurer;
        }

        @ConditionalOnMissingBean(name={"forgotUsernameValidateCaptchaAction"})
        @RefreshScope
        @Bean
        public Action forgotUsernameValidateCaptchaAction() {
            GoogleRecaptchaProperties recaptcha = PasswordManagementForgotUsernameConfiguration.this.casProperties.getAuthn().getPm().getForgotUsername().getGoogleRecaptcha();
            return new ValidateCaptchaAction(CaptchaValidator.getInstance((GoogleRecaptchaProperties)recaptcha));
        }

        @RefreshScope
        @Bean
        @ConditionalOnMissingBean(name={"forgotUsernameInitializeCaptchaAction"})
        public Action forgotUsernameInitializeCaptchaAction() {
            final GoogleRecaptchaProperties recaptcha = PasswordManagementForgotUsernameConfiguration.this.casProperties.getAuthn().getPm().getForgotUsername().getGoogleRecaptcha();
            return new InitializeCaptchaAction(recaptcha){

                protected Event doExecute(RequestContext requestContext) {
                    WebUtils.putRecaptchaForgotUsernameEnabled((RequestContext)requestContext, (GoogleRecaptchaProperties)recaptcha);
                    return super.doExecute(requestContext);
                }
            };
        }

        @Bean
        @Autowired
        @ConditionalOnMissingBean(name={"forgotUsernameCaptchaWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer forgotUsernameCaptchaWebflowExecutionPlanConfigurer(@Qualifier(value="forgotUsernameCaptchaWebflowConfigurer") CasWebflowConfigurer cfg) {
            return plan -> plan.registerWebflowConfigurer(cfg);
        }
    }
}

