/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.logout.LogoutPostProcessor;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.web.cookie.CookieGenerationContext;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.gen.CookieRetrievingCookieGenerator;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(transactionManager="ticketTransactionManager")
public class DistributedJ2ESessionStore
implements SessionStore<JEEContext>,
LogoutPostProcessor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedJ2ESessionStore.class);
    private static final String SESSION_ID_IN_REQUEST_ATTRIBUTE = "sessionIdInRequestAttribute";
    private final TicketRegistry ticketRegistry;
    private final TicketFactory ticketFactory;
    private final CookieRetrievingCookieGenerator cookieGenerator;

    public DistributedJ2ESessionStore(TicketRegistry ticketRegistry, TicketFactory ticketFactory, CasConfigurationProperties casProperties) {
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
        CookieGenerationContext context = CookieUtils.buildCookieGenerationContext((CookieProperties)casProperties.getSessionReplication());
        this.cookieGenerator = new CookieRetrievingCookieGenerator(context);
    }

    public String getOrCreateSessionId(JEEContext context) {
        String sessionId = context.getRequestAttribute(SESSION_ID_IN_REQUEST_ATTRIBUTE).orElse(null);
        if (sessionId == null) {
            sessionId = this.cookieGenerator.retrieveCookieValue(context.getNativeRequest());
        }
        LOGGER.trace("retrieved sessionId: {}", (Object)sessionId);
        if (sessionId == null) {
            sessionId = UUID.randomUUID().toString();
            LOGGER.debug("generated sessionId: {}", (Object)sessionId);
            this.cookieGenerator.addCookie(context.getNativeRequest(), context.getNativeResponse(), sessionId);
            context.setRequestAttribute(SESSION_ID_IN_REQUEST_ATTRIBUTE, (Object)sessionId);
        }
        return sessionId;
    }

    public Optional get(JEEContext context, String key) {
        LOGGER.trace("getting key: {}", (Object)key);
        TransientSessionTicket ticket = this.getTransientSessionTicketForSession(context);
        if (ticket == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(ticket.getProperties().get(key));
    }

    public void set(JEEContext context, String key, Object value) {
        LOGGER.trace("setting key: {}", (Object)key);
        String sessionId = this.getOrCreateSessionId(context);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        if (value instanceof Serializable) {
            properties.put(key, (Serializable)value);
        } else if (value != null) {
            LOGGER.trace("Object value [{}] assigned to [{}] is not serializable and may not be part of the ticket [{}]", new Object[]{value, key, sessionId});
        }
        TransientSessionTicket ticket = this.getTransientSessionTicketForSession(context);
        if (value == null && ticket != null) {
            ticket.getProperties().remove(key);
            this.ticketRegistry.updateTicket((Ticket)ticket);
            LOGGER.trace("updated ticket: {}", (Object)ticket.getId());
        } else if (ticket == null) {
            TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
            ticket = transientFactory.create(sessionId, properties);
            this.ticketRegistry.addTicket((Ticket)ticket);
            LOGGER.trace("added ticket: {}", (Object)ticket.getId());
        } else {
            ticket.getProperties().putAll(properties);
            this.ticketRegistry.updateTicket((Ticket)ticket);
            LOGGER.trace("updated ticket: {}", (Object)ticket.getId());
        }
    }

    private TransientSessionTicket getTransientSessionTicketForSession(JEEContext context) {
        String sessionId = this.getOrCreateSessionId(context);
        String ticketId = TransientSessionTicketFactory.normalizeTicketId((String)sessionId);
        LOGGER.trace("fetching ticket: {}", (Object)ticketId);
        TransientSessionTicket ticket = (TransientSessionTicket)this.ticketRegistry.getTicket(ticketId, TransientSessionTicket.class);
        if (ticket == null || ticket.isExpired()) {
            LOGGER.trace("ticket {} does not exist or is expired", (Object)ticketId);
            return null;
        }
        return ticket;
    }

    public void handle(TicketGrantingTicket ticketGrantingTicket) {
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        HttpServletResponse response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
        if (request != null && response != null) {
            this.destroySession(new JEEContext(request, response, (SessionStore)this));
        }
    }

    public boolean destroySession(JEEContext context) {
        try {
            String sessionId = this.getOrCreateSessionId(context);
            String ticketId = TransientSessionTicketFactory.normalizeTicketId((String)sessionId);
            this.ticketRegistry.deleteTicket(ticketId);
            this.cookieGenerator.removeCookie(context.getNativeResponse());
            LOGGER.trace("remove session cookie and ticket: {}", (Object)ticketId);
            return true;
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Optional getTrackableSession(JEEContext context) {
        String sessionId = this.getOrCreateSessionId(context);
        LOGGER.trace("track sessionId: {}", (Object)sessionId);
        return Optional.of(sessionId);
    }

    public Optional<SessionStore<JEEContext>> buildFromTrackableSession(JEEContext context, Object trackableSession) {
        context.setRequestAttribute(SESSION_ID_IN_REQUEST_ATTRIBUTE, trackableSession);
        LOGGER.trace("force sessionId: {}", trackableSession);
        return Optional.of(this);
    }

    public boolean renewSession(JEEContext context) {
        return false;
    }
}

