/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.authentication.principal;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.AbstractWebApplicationServiceResponseBuilder;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.openid.authentication.principal.OpenIdService;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.validation.Assertion;
import org.openid4java.association.Association;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;
import org.openid4java.server.RealmVerifier;
import org.openid4java.server.ServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="6.2.0")
public class OpenIdServiceResponseBuilder
extends AbstractWebApplicationServiceResponseBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIdServiceResponseBuilder.class);
    private static final long serialVersionUID = -4581238964007702423L;
    private final ServerManager serverManager;
    private final transient CentralAuthenticationService centralAuthenticationService;
    private final String openIdPrefixUrl;

    public OpenIdServiceResponseBuilder(String openIdPrefixUrl, ServerManager serverManager, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager) {
        super(servicesManager);
        this.serverManager = serverManager;
        this.openIdPrefixUrl = openIdPrefixUrl;
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public Response build(WebApplicationService webApplicationService, String ticketId, Authentication authentication) {
        OpenIdService service = (OpenIdService)webApplicationService;
        ParameterList parameterList = new ParameterList(HttpRequestUtils.getHttpServletRequestFromRequestAttributes().getParameterMap());
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)ticketId)) {
            parameters.put("openid.mode", "cancel");
            return this.buildRedirect((WebApplicationService)service, parameters);
        }
        Association association = this.getAssociation(this.serverManager, parameterList);
        boolean associated = association != null;
        boolean associationValid = this.isAssociationValid(association);
        boolean successFullAuthentication = true;
        Assertion assertion = null;
        try {
            if (associated && associationValid) {
                assertion = this.centralAuthenticationService.validateServiceTicket(ticketId, (Service)service);
                LOGGER.debug("Validated openid ticket [{}] for [{}]", (Object)ticketId, (Object)service);
            } else if (!associated) {
                LOGGER.debug("Responding to non-associated mode. Service ticket [{}] must be validated by the RP", (Object)ticketId);
            } else {
                LOGGER.warn("Association does not exist or is not valid");
                successFullAuthentication = false;
            }
        }
        catch (AbstractTicketException e) {
            LOGGER.error("Could not validate ticket : [{}]", (Object)e.getMessage(), (Object)e);
            successFullAuthentication = false;
        }
        String id = this.determineIdentity(service, assertion);
        return this.buildAuthenticationResponse(service, parameters, successFullAuthentication, id, parameterList);
    }

    protected String determineIdentity(OpenIdService service, Assertion assertion) {
        if (assertion != null && "http://specs.openid.net/auth/2.0/identifier_select".equals(service.getIdentity())) {
            return this.openIdPrefixUrl + "/" + assertion.getPrimaryAuthentication().getPrincipal().getId();
        }
        return service.getIdentity();
    }

    protected Response buildAuthenticationResponse(OpenIdService service, Map<String, String> parameters, boolean successFullAuthentication, String id, ParameterList parameterList) {
        Message response = this.serverManager.authResponse(parameterList, id, id, successFullAuthentication, true);
        parameters.putAll(response.getParameterMap());
        LOGGER.debug("Parameters passed for the OpenID response are [{}]", parameters.keySet());
        return this.buildRedirect((WebApplicationService)service, parameters);
    }

    protected Association getAssociation(ServerManager serverManager, ParameterList parameterList) {
        try {
            String assocHandle;
            AuthRequest authReq = AuthRequest.createAuthRequest((ParameterList)parameterList, (RealmVerifier)serverManager.getRealmVerifier());
            Map parameterMap = authReq.getParameterMap();
            if (parameterMap != null && !parameterMap.isEmpty() && (assocHandle = (String)parameterMap.get("openid.assoc_handle")) != null) {
                return serverManager.getSharedAssociations().load(assocHandle);
            }
        }
        catch (MessageException e) {
            LOGGER.error("Message exception : [{}]", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    public boolean supports(WebApplicationService service) {
        return service instanceof OpenIdService;
    }

    protected boolean isAssociationValid(Association association) {
        return association != null && !association.hasExpired();
    }
}

