/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.apereo.cas.web.AbstractDelegateController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class DelegatingController
extends AbstractController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingController.class);
    private static final String DEFAULT_ERROR_VIEW_NAME = "casServiceFailureView";
    private List<AbstractDelegateController> delegates;
    private String failureView = "casServiceFailureView";

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        for (AbstractDelegateController delegate : this.delegates) {
            if (!delegate.canHandle(request, response)) continue;
            return delegate.handleRequestInternal(request, response);
        }
        return this.generateErrorView("INVALID_REQUEST", null);
    }

    private ModelAndView generateErrorView(String code, Object[] args) {
        ModelAndView modelAndView = new ModelAndView(this.failureView);
        String convertedDescription = this.getMessageSourceAccessor().getMessage(code, args, code);
        modelAndView.addObject("code", (Object)StringEscapeUtils.escapeHtml4((String)code));
        modelAndView.addObject("description", (Object)StringEscapeUtils.escapeHtml4((String)convertedDescription));
        return modelAndView;
    }

    @Generated
    public void setDelegates(List<AbstractDelegateController> delegates) {
        this.delegates = delegates;
    }

    @Generated
    public void setFailureView(String failureView) {
        this.failureView = failureView;
    }
}

