/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.web.mvc;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizersExecutionPlan;
import org.apereo.cas.web.AbstractServiceValidateController;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.openid4java.message.ParameterList;
import org.openid4java.message.VerifyResponse;
import org.openid4java.server.ServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class OpenIdValidateController
extends AbstractServiceValidateController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIdValidateController.class);
    private final ServerManager serverManager;

    public OpenIdValidateController(CasProtocolValidationSpecification validationSpecification, AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager, CentralAuthenticationService centralAuthenticationService, ProxyHandler proxyHandler, ArgumentExtractor argumentExtractor, MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy, AuthenticationContextValidator authenticationContextValidator, View jsonView, View successView, View failureView, String authnContextAttribute, ServerManager serverManager, ServiceTicketValidationAuthorizersExecutionPlan validationAuthorizers, boolean renewEnabled) {
        super(CollectionUtils.wrapSet((Object)validationSpecification), validationAuthorizers, authenticationSystemSupport, servicesManager, centralAuthenticationService, proxyHandler, successView, failureView, argumentExtractor, multifactorTriggerSelectionStrategy, authenticationContextValidator, jsonView, authnContextAttribute, renewEnabled);
        this.serverManager = serverManager;
    }

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String openIdMode = request.getParameter("openid.mode");
        if (StringUtils.equals((CharSequence)openIdMode, (CharSequence)"check_authentication")) {
            VerifyResponse message = (VerifyResponse)this.serverManager.verify(new ParameterList(request.getParameterMap()));
            HashMap parameters = new HashMap();
            parameters.putAll(message.getParameterMap());
            if (message.isSignatureVerified()) {
                LOGGER.debug("Signature verification request successful.");
                return new ModelAndView(this.getSuccessView(), parameters);
            }
            LOGGER.debug("Signature verification request unsuccessful.");
            return new ModelAndView(this.getFailureView(), parameters);
        }
        return super.handleRequestInternal(request, response);
    }

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        String openIdMode = request.getParameter("openid.mode");
        if (StringUtils.equals((CharSequence)openIdMode, (CharSequence)"check_authentication")) {
            LOGGER.info("Handling request. openid.mode : [{}]", (Object)openIdMode);
            return true;
        }
        LOGGER.info("Cannot handle request. openid.mode : [{}]", (Object)openIdMode);
        return false;
    }
}

