/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.web.flow;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.openid.authentication.principal.OpenIdCredential;
import org.apereo.cas.support.openid.authentication.principal.OpenIdService;
import org.apereo.cas.support.openid.web.support.DefaultOpenIdUserNameExtractor;
import org.apereo.cas.support.openid.web.support.OpenIdUserNameExtractor;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.actions.AbstractNonInteractiveCredentialsAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class OpenIdSingleSignOnAction
extends AbstractNonInteractiveCredentialsAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIdSingleSignOnAction.class);
    private OpenIdUserNameExtractor extractor = new DefaultOpenIdUserNameExtractor();
    private final TicketRegistrySupport ticketRegistrySupport;

    public OpenIdSingleSignOnAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, OpenIdUserNameExtractor extractor, TicketRegistrySupport ticketRegistrySupport) {
        super(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
        this.extractor = extractor;
        this.ticketRegistrySupport = ticketRegistrySupport;
    }

    protected Credential constructCredentialsFromRequest(RequestContext context) {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        String openidIdentityParameter = context.getRequestParameters().get("openid.identity");
        String userName = this.getOpenIdSelectedIdentifier(context, ticketGrantingTicketId, openidIdentityParameter);
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        if (service instanceof OpenIdService && StringUtils.isBlank((CharSequence)userName)) {
            context.getFlowScope().remove("service");
        }
        if (StringUtils.isBlank((CharSequence)ticketGrantingTicketId) || StringUtils.isBlank((CharSequence)userName)) {
            return null;
        }
        return new OpenIdCredential(ticketGrantingTicketId, userName);
    }

    private String getOpenIdSelectedIdentifier(RequestContext context, String ticketGrantingTicketId, String openidIdentityParameter) {
        if ("http://specs.openid.net/auth/2.0/identifier_select".equals(openidIdentityParameter)) {
            context.getFlowScope().remove("openIdLocalId");
            Principal p = this.ticketRegistrySupport.getAuthenticatedPrincipalFrom(ticketGrantingTicketId);
            if (p != null) {
                return p.getId();
            }
            return "http://specs.openid.net/auth/2.0/identifier_select";
        }
        String userName = this.extractor.extractLocalUsernameFromUri(openidIdentityParameter);
        context.getFlowScope().put("openIdLocalId", (Object)userName);
        return userName;
    }
}

