/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Properties;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.openid.authentication.principal.OpenIdServiceResponseBuilder;
import org.apereo.cas.support.openid.web.OpenIdProviderController;
import org.apereo.cas.support.openid.web.flow.OpenIdSingleSignOnAction;
import org.apereo.cas.support.openid.web.mvc.OpenIdValidateController;
import org.apereo.cas.support.openid.web.mvc.SmartOpenIdController;
import org.apereo.cas.support.openid.web.mvc.YadisController;
import org.apereo.cas.support.openid.web.support.DefaultOpenIdUserNameExtractor;
import org.apereo.cas.support.openid.web.support.OpenIdPostUrlHandlerMapping;
import org.apereo.cas.support.openid.web.support.OpenIdUserNameExtractor;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizersExecutionPlan;
import org.apereo.cas.web.AbstractDelegateController;
import org.apereo.cas.web.DelegatingController;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.openid4java.server.InMemoryServerAssociationStore;
import org.openid4java.server.ServerAssociationStore;
import org.openid4java.server.ServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;
import org.springframework.webflow.execution.Action;

@Configuration(value="openidConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OpenIdConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIdConfiguration.class);
    @Autowired
    @Qualifier(value="adaptiveAuthenticationPolicy")
    private AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy;
    @Autowired
    @Qualifier(value="serviceTicketRequestWebflowEventResolver")
    private CasWebflowEventResolver serviceTicketRequestWebflowEventResolver;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="cas3ServiceJsonView")
    private View cas3ServiceJsonView;
    @Autowired
    @Qualifier(value="casOpenIdServiceSuccessView")
    private View casOpenIdServiceSuccessView;
    @Autowired
    @Qualifier(value="casOpenIdServiceFailureView")
    private View casOpenIdServiceFailureView;
    @Autowired
    @Qualifier(value="casOpenIdAssociationSuccessView")
    private View casOpenIdAssociationSuccessView;
    @Autowired
    @Qualifier(value="proxy20Handler")
    private ProxyHandler proxy20Handler;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="authenticationContextValidator")
    private AuthenticationContextValidator authenticationContextValidator;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification")
    private CasProtocolValidationSpecification cas20WithoutProxyProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="defaultMultifactorTriggerSelectionStrategy")
    private MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;
    @Autowired
    @Qualifier(value="serviceValidationAuthorizers")
    private ServiceTicketValidationAuthorizersExecutionPlan validationAuthorizers;

    @Bean
    public AbstractDelegateController smartOpenIdAssociationController() {
        return new SmartOpenIdController(this.serverManager(), this.casOpenIdAssociationSuccessView);
    }

    @RefreshScope
    @Bean
    public ServerManager serverManager() {
        ServerManager manager = new ServerManager();
        manager.setOPEndpointUrl(this.casProperties.getServer().getLoginUrl());
        manager.setEnforceRpId(this.casProperties.getAuthn().getOpenid().isEnforceRpId());
        manager.setSharedAssociations((ServerAssociationStore)new InMemoryServerAssociationStore());
        LOGGER.info("Creating openid server manager with OP endpoint [{}]", (Object)this.casProperties.getServer().getLoginUrl());
        return manager;
    }

    @ConditionalOnMissingBean(name={"openIdServiceResponseBuilder"})
    @Bean
    public ResponseBuilder openIdServiceResponseBuilder() {
        String openIdPrefixUrl = this.casProperties.getServer().getPrefix().concat("/openid");
        return new OpenIdServiceResponseBuilder(openIdPrefixUrl, this.serverManager(), this.centralAuthenticationService, this.servicesManager);
    }

    @Bean
    @RefreshScope
    public YadisController yadisController() {
        return new YadisController();
    }

    @Bean
    @RefreshScope
    public OpenIdProviderController openIdProviderController() {
        return new OpenIdProviderController();
    }

    @Bean
    public Action openIdSingleSignOnAction() {
        return new OpenIdSingleSignOnAction(this.initialAuthenticationAttemptWebflowEventResolver, this.serviceTicketRequestWebflowEventResolver, this.adaptiveAuthenticationPolicy, this.defaultOpenIdUserNameExtractor(), this.ticketRegistrySupport);
    }

    @Bean
    public OpenIdUserNameExtractor defaultOpenIdUserNameExtractor() {
        return new DefaultOpenIdUserNameExtractor();
    }

    @Autowired
    @Bean
    public OpenIdPostUrlHandlerMapping openIdPostUrlHandlerMapping(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor) {
        OpenIdValidateController c = new OpenIdValidateController(this.cas20WithoutProxyProtocolValidationSpecification, this.authenticationSystemSupport, this.servicesManager, this.centralAuthenticationService, this.proxy20Handler, argumentExtractor, this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView, this.casOpenIdServiceSuccessView, this.casOpenIdServiceFailureView, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serverManager(), this.validationAuthorizers, this.casProperties.getSso().isRenewAuthnEnabled());
        DelegatingController controller = new DelegatingController();
        controller.setDelegates(CollectionUtils.wrapList((Object[])new AbstractDelegateController[]{this.smartOpenIdAssociationController(), c}));
        OpenIdPostUrlHandlerMapping m = new OpenIdPostUrlHandlerMapping();
        m.setOrder(1);
        Properties mappings = new Properties();
        mappings.put("/login", (Object)controller);
        m.setMappings(mappings);
        return m;
    }
}

