/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import java.util.Collection;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.openid.authentication.principal.OpenIdServiceFactory;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="openIdServiceFactoryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OpenIdServiceFactoryConfiguration
implements ServiceFactoryConfigurer {
    @Autowired
    private CasConfigurationProperties casProperties;

    public Collection<ServiceFactory<? extends WebApplicationService>> buildServiceFactories() {
        return CollectionUtils.wrap((Object)((Object)this.openIdServiceFactory()));
    }

    @Bean
    @RefreshScope
    public OpenIdServiceFactory openIdServiceFactory() {
        return new OpenIdServiceFactory(this.casProperties.getServer().getPrefix().concat("/openid"));
    }
}

