/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.web.mvc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.web.AbstractDelegateController;
import org.openid4java.message.Message;
import org.openid4java.message.ParameterList;
import org.openid4java.server.ServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class SmartOpenIdController
extends AbstractDelegateController
implements Serializable {
    private static final long serialVersionUID = -594058549445950430L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartOpenIdController.class);
    private final ServerManager serverManager;
    private final View successView;

    public SmartOpenIdController(ServerManager serverManager, View successView) {
        this.serverManager = serverManager;
        this.successView = successView;
    }

    public Map<String, String> getAssociationResponse(HttpServletRequest request) {
        ParameterList parameters = new ParameterList(request.getParameterMap());
        String mode = parameters.hasParameter("openid.mode") ? parameters.getParameterValue("openid.mode") : null;
        Message response = null;
        if (StringUtils.equals((CharSequence)mode, (CharSequence)"associate")) {
            response = this.serverManager.associationResponse(parameters);
        }
        HashMap<String, String> responseParams = new HashMap<String, String>();
        if (response != null) {
            responseParams.putAll(response.getParameterMap());
        }
        return responseParams;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(this.getAssociationResponse(request));
        return new ModelAndView(this.successView, parameters);
    }

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        String openIdMode = request.getParameter("openid.mode");
        if (StringUtils.equals((CharSequence)openIdMode, (CharSequence)"associate")) {
            LOGGER.info("Handling request. openid.mode : [{}]", (Object)openIdMode);
            return true;
        }
        LOGGER.info("Cannot handle request. openid.mode : [{}]", (Object)openIdMode);
        return false;
    }
}

