/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilderConfigurer;
import org.apereo.cas.logout.slo.SingleLogoutServiceMessageHandler;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.slo.OidcSingleLogoutMessageCreator;
import org.apereo.cas.oidc.slo.OidcSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.oidc.slo.OidcSingleLogoutServiceMessageHandler;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.UrlValidator;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OpenIDConnect})
@Configuration(value="OidcLogoutConfiguration", proxyBeanMethods=false)
class OidcLogoutConfiguration {
    OidcLogoutConfiguration() {
    }

    @Configuration(value="OidcLogoutExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcLogoutExecutionPlanConfiguration {
        OidcLogoutExecutionPlanConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcLogoutExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LogoutExecutionPlanConfigurer oidcLogoutExecutionPlanConfigurer(@Qualifier(value="oidcSingleLogoutServiceMessageHandler") SingleLogoutServiceMessageHandler oidcSingleLogoutServiceMessageHandler) {
            return plan -> plan.registerSingleLogoutServiceMessageHandler(oidcSingleLogoutServiceMessageHandler);
        }
    }

    @Configuration(value="OidcLogoutHandlerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcLogoutHandlerConfiguration {
        OidcLogoutHandlerConfiguration() {
        }

        @ConditionalOnMissingBean(name={"oidcSingleLogoutServiceMessageHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutServiceMessageHandler oidcSingleLogoutServiceMessageHandler(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="oidcSingleLogoutMessageCreator") SingleLogoutMessageCreator oidcSingleLogoutMessageCreator, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="singleLogoutServiceLogoutUrlBuilder") SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder, @Qualifier(value="noRedirectHttpClient") HttpClient httpClient, @Qualifier(value="oidcIssuerService") OidcIssuerService oidcIssuerService) {
            return new OidcSingleLogoutServiceMessageHandler(httpClient, oidcSingleLogoutMessageCreator, servicesManager, singleLogoutServiceLogoutUrlBuilder, casProperties.getSlo().isAsynchronous(), authenticationServiceSelectionPlan, oidcIssuerService);
        }
    }

    @Configuration(value="OidcLogoutMessageConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcLogoutMessageConfiguration {
        OidcLogoutMessageConfiguration() {
        }

        @ConditionalOnMissingBean(name={"oidcSingleLogoutMessageCreator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutMessageCreator oidcSingleLogoutMessageCreator(@Qualifier(value="oidcConfigurationContext") ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
            return new OidcSingleLogoutMessageCreator(oidcConfigurationContext);
        }
    }

    @Configuration(value="OidcLogoutBuilderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcLogoutBuilderConfiguration {
        OidcLogoutBuilderConfiguration() {
        }

        @ConditionalOnMissingBean(name={"oidcSingleLogoutServiceLogoutUrlBuilderConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutServiceLogoutUrlBuilderConfigurer oidcSingleLogoutServiceLogoutUrlBuilderConfigurer(@Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="urlValidator") UrlValidator urlValidator) {
            return () -> new OidcSingleLogoutServiceLogoutUrlBuilder(servicesManager, urlValidator);
        }
    }
}

