/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.BaseOidcScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.mapping.DefaultOidcAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.claims.mapping.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettingsFactory;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequestSerializer;
import org.apereo.cas.oidc.jwks.OidcDefaultJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.OidcServiceJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.profile.OidcProfileScopeToAttributesFilter;
import org.apereo.cas.oidc.profile.OidcRegisteredServicePreProcessorEventListener;
import org.apereo.cas.oidc.profile.OidcUserProfileDataCreator;
import org.apereo.cas.oidc.token.OidcIdTokenGeneratorService;
import org.apereo.cas.oidc.token.OidcIdTokenSigningAndEncryptionService;
import org.apereo.cas.oidc.util.OidcAuthorizationRequestSupport;
import org.apereo.cas.oidc.web.OidcAccessTokenResponseGenerator;
import org.apereo.cas.oidc.web.OidcCallbackAuthorizeViewResolver;
import org.apereo.cas.oidc.web.OidcCasClientRedirectActionBuilder;
import org.apereo.cas.oidc.web.OidcConsentApprovalViewResolver;
import org.apereo.cas.oidc.web.OidcHandlerInterceptorAdapter;
import org.apereo.cas.oidc.web.OidcImplicitIdTokenAuthorizationResponseBuilder;
import org.apereo.cas.oidc.web.OidcSecurityInterceptor;
import org.apereo.cas.oidc.web.controllers.OidcAccessTokenEndpointController;
import org.apereo.cas.oidc.web.controllers.OidcAuthorizeEndpointController;
import org.apereo.cas.oidc.web.controllers.OidcDynamicClientRegistrationEndpointController;
import org.apereo.cas.oidc.web.controllers.OidcIntrospectionEndpointController;
import org.apereo.cas.oidc.web.controllers.OidcJwksEndpointController;
import org.apereo.cas.oidc.web.controllers.OidcRevocationEndpointController;
import org.apereo.cas.oidc.web.controllers.OidcUserProfileEndpointController;
import org.apereo.cas.oidc.web.controllers.OidcWellKnownEndpointController;
import org.apereo.cas.oidc.web.flow.OidcAuthenticationContextWebflowEventResolver;
import org.apereo.cas.oidc.web.flow.OidcRegisteredServiceUIAction;
import org.apereo.cas.oidc.web.flow.OidcWebflowConfigurer;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.gen.DefaultRandomStringGenerator;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.authentication.RankedMultifactorAuthenticationProviderSelector;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.jose4j.jwk.RsaJsonWebKey;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.config.Config;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="oidcConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OidcConfiguration
extends WebMvcConfigurerAdapter
implements CasWebflowExecutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcConfiguration.class);
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private AuditableExecution registeredServiceAccessStrategyEnforcer;
    @Autowired
    @Qualifier(value="oauthAuthorizationRequestValidators")
    private Set<OAuth20AuthorizationRequestValidator> oauthRequestValidators;
    @Autowired
    @Qualifier(value="grantingTicketExpirationPolicy")
    private ExpirationPolicy grantingTicketExpirationPolicy;
    @Autowired
    @Qualifier(value="oauthTokenGenerator")
    private OAuth20TokenGenerator oauthTokenGenerator;
    @Autowired
    @Qualifier(value="oauthAuthorizationResponseBuilders")
    private Set<OAuth20AuthorizationResponseBuilder> oauthAuthorizationResponseBuilders;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="accessTokenExpirationPolicy")
    private ExpirationPolicy accessTokenExpirationPolicy;
    @Autowired
    @Qualifier(value="requiresAuthenticationAccessTokenInterceptor")
    private SecurityInterceptor requiresAuthenticationAccessTokenInterceptor;
    @Autowired(required=false)
    @Qualifier(value="multifactorAuthenticationProviderSelector")
    private MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector = new RankedMultifactorAuthenticationProviderSelector();
    @Autowired
    @Qualifier(value="oauthCasAuthenticationBuilder")
    private OAuth20CasAuthenticationBuilder authenticationBuilder;
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private CookieGenerator warnCookieGenerator;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="logoutFlowRegistry")
    private FlowDefinitionRegistry logoutFlowDefinitionRegistry;
    @Autowired
    private FlowBuilderServices flowBuilderServices;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="oauth20AuthenticationRequestServiceSelectionStrategy")
    private AuthenticationServiceSelectionStrategy oauth20AuthenticationServiceSelectionStrategy;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    @Qualifier(value="oauthSecConfig")
    private Config oauthSecConfig;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CookieRetrievingCookieGenerator> ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;
    @Autowired
    @Qualifier(value="defaultAccessTokenFactory")
    private AccessTokenFactory defaultAccessTokenFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;
    @Autowired
    @Qualifier(value="defaultOAuthCodeFactory")
    private OAuthCodeFactory defaultOAuthCodeFactory;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="oauthUserProfileViewRenderer")
    private OAuth20UserProfileViewRenderer oauthUserProfileViewRenderer;
    @Autowired
    @Qualifier(value="accessTokenGrantRequestExtractors")
    private Collection<BaseAccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors;
    @Autowired
    @Qualifier(value="oauthTokenRequestValidators")
    private Collection<OAuth20TokenRequestValidator> oauthTokenRequestValidators;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.oauthInterceptor()).addPathPatterns(new String[]{'/' + "oidc".concat("/").concat("*")});
    }

    @Bean
    public ConsentApprovalViewResolver consentApprovalViewResolver() {
        return new OidcConsentApprovalViewResolver(this.casProperties);
    }

    @Bean
    public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver() {
        return new OidcCallbackAuthorizeViewResolver(this.oidcAuthorizationRequestSupport());
    }

    @Bean
    public OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder() {
        return new OidcCasClientRedirectActionBuilder(this.oidcAuthorizationRequestSupport());
    }

    @Bean
    public HandlerInterceptorAdapter requiresAuthenticationDynamicRegistrationInterceptor() {
        String clients = Stream.of("clientBasicAuth", "clientForm", "userForm").collect(Collectors.joining(","));
        return new SecurityInterceptor(this.oauthSecConfig, clients);
    }

    @Bean
    public HandlerInterceptorAdapter requiresAuthenticationAuthorizeInterceptor() {
        String name = ((CasClient)this.oauthSecConfig.getClients().findClient(CasClient.class)).getName();
        return new OidcSecurityInterceptor(this.oauthSecConfig, name, this.oidcAuthorizationRequestSupport());
    }

    @Bean
    public OAuth20CasClientRedirectActionBuilder oidcCasClientRedirectActionBuilder() {
        return new OidcCasClientRedirectActionBuilder(this.oidcAuthorizationRequestSupport());
    }

    @RefreshScope
    @Bean
    public OidcIdTokenGeneratorService oidcIdTokenGenerator() {
        return new OidcIdTokenGeneratorService(this.casProperties, this.oidcTokenSigningAndEncryptionService(), this.servicesManager);
    }

    @Bean
    @RefreshScope
    public AccessTokenResponseGenerator oidcAccessTokenResponseGenerator() {
        return new OidcAccessTokenResponseGenerator(this.oidcIdTokenGenerator());
    }

    @Bean
    public OidcAuthorizationRequestSupport oidcAuthorizationRequestSupport() {
        return new OidcAuthorizationRequestSupport((CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), this.ticketRegistrySupport);
    }

    @ConditionalOnMissingBean(name={"oidcPrincipalFactory"})
    @Bean
    public PrincipalFactory oidcPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    public OidcAttributeToScopeClaimMapper oidcAttributeToScopeClaimMapper() {
        Map mappings = this.casProperties.getAuthn().getOidc().getClaimsMap();
        return new DefaultOidcAttributeToScopeClaimMapper(mappings);
    }

    @Bean
    public OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter() {
        return new OidcProfileScopeToAttributesFilter(this.oidcPrincipalFactory(), this.servicesManager, this.userDefinedScopeBasedAttributeReleasePolicies(), this.casProperties);
    }

    @RefreshScope
    @Bean
    public OidcIntrospectionEndpointController oidcIntrospectionEndpointController() {
        return new OidcIntrospectionEndpointController(this.servicesManager, this.ticketRegistry, this.defaultAccessTokenFactory, this.oidcPrincipalFactory(), this.webApplicationServiceFactory, this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), this.centralAuthenticationService, this.registeredServiceAccessStrategyEnforcer);
    }

    @RefreshScope
    @Bean
    public OidcRevocationEndpointController oidcRevocationEndpointController() {
        return new OidcRevocationEndpointController(this.servicesManager, this.ticketRegistry, this.defaultAccessTokenFactory, this.oidcPrincipalFactory(), this.webApplicationServiceFactory, this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), this.registeredServiceAccessStrategyEnforcer);
    }

    @RefreshScope
    @Bean
    public OidcAccessTokenEndpointController oidcAccessTokenController() {
        return new OidcAccessTokenEndpointController(this.servicesManager, this.ticketRegistry, this.defaultAccessTokenFactory, this.oidcPrincipalFactory(), this.webApplicationServiceFactory, this.oauthTokenGenerator, this.oidcAccessTokenResponseGenerator(), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), this.accessTokenExpirationPolicy, this.accessTokenGrantRequestExtractors, this.oauthTokenRequestValidators);
    }

    @ConditionalOnMissingBean(name={"clientRegistrationRequestSerializer"})
    @Bean
    public StringSerializer<OidcClientRegistrationRequest> clientRegistrationRequestSerializer() {
        return new OidcClientRegistrationRequestSerializer();
    }

    @RefreshScope
    @Bean
    public OidcDynamicClientRegistrationEndpointController oidcDynamicClientRegistrationEndpointController() {
        return new OidcDynamicClientRegistrationEndpointController(this.servicesManager, this.ticketRegistry, this.defaultAccessTokenFactory, this.oidcPrincipalFactory(), this.webApplicationServiceFactory, this.clientRegistrationRequestSerializer(), (RandomStringGenerator)new DefaultRandomStringGenerator(), (RandomStringGenerator)new DefaultRandomStringGenerator(), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable());
    }

    @RefreshScope
    @Bean
    public OidcJwksEndpointController oidcJwksController() {
        return new OidcJwksEndpointController(this.servicesManager, this.ticketRegistry, this.defaultAccessTokenFactory, this.oidcPrincipalFactory(), this.webApplicationServiceFactory, this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable());
    }

    @Autowired
    @RefreshScope
    @Bean
    public OidcWellKnownEndpointController oidcWellKnownController(@Qualifier(value="oidcServerDiscoverySettingsFactory") OidcServerDiscoverySettings discoverySettings) {
        return new OidcWellKnownEndpointController(this.servicesManager, this.ticketRegistry, this.defaultAccessTokenFactory, this.oidcPrincipalFactory(), this.webApplicationServiceFactory, discoverySettings, this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable());
    }

    @RefreshScope
    @Bean
    public OidcUserProfileEndpointController oidcProfileController() {
        return new OidcUserProfileEndpointController(this.servicesManager, this.ticketRegistry, this.defaultAccessTokenFactory, this.oidcPrincipalFactory(), this.webApplicationServiceFactory, this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), this.oauthUserProfileViewRenderer, this.oidcUserProfileDataCreator());
    }

    @Bean
    public OAuth20UserProfileDataCreator oidcUserProfileDataCreator() {
        return new OidcUserProfileDataCreator(this.servicesManager, this.profileScopeToAttributesFilter());
    }

    @RefreshScope
    @Bean
    public OidcAuthorizeEndpointController oidcAuthorizeController() {
        return new OidcAuthorizeEndpointController(this.servicesManager, this.ticketRegistry, this.defaultAccessTokenFactory, this.oidcPrincipalFactory(), this.webApplicationServiceFactory, this.defaultOAuthCodeFactory, this.consentApprovalViewResolver(), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), this.authenticationBuilder, this.oauthAuthorizationResponseBuilders, this.oauthRequestValidators, this.registeredServiceAccessStrategyEnforcer);
    }

    @RefreshScope
    @Bean
    public CasWebflowEventResolver oidcAuthenticationContextWebflowEventResolver() {
        OidcAuthenticationContextWebflowEventResolver r = new OidcAuthenticationContextWebflowEventResolver((AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable(), this.centralAuthenticationService, this.servicesManager, this.ticketRegistrySupport, this.warnCookieGenerator, this.authenticationRequestServiceSelectionStrategies, this.multifactorAuthenticationProviderSelector);
        this.initialAuthenticationAttemptWebflowEventResolver.addDelegate((CasWebflowEventResolver)r);
        return r;
    }

    @ConditionalOnMissingBean(name={"oidcWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer oidcWebflowConfigurer() {
        OidcWebflowConfigurer cfg = new OidcWebflowConfigurer(this.flowBuilderServices, this.loginFlowDefinitionRegistry, this.oidcRegisteredServiceUIAction(), this.applicationContext, this.casProperties);
        cfg.setLogoutFlowDefinitionRegistry(this.logoutFlowDefinitionRegistry);
        return cfg;
    }

    @ConditionalOnMissingBean(name={"oidcRegisteredServiceUIAction"})
    @Bean
    public Action oidcRegisteredServiceUIAction() {
        return new OidcRegisteredServiceUIAction(this.servicesManager, this.oauth20AuthenticationServiceSelectionStrategy);
    }

    @Bean
    public OidcIdTokenSigningAndEncryptionService oidcTokenSigningAndEncryptionService() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return new OidcIdTokenSigningAndEncryptionService(this.oidcDefaultJsonWebKeystoreCache(), this.oidcServiceJsonWebKeystoreCache(), oidc.getIssuer());
    }

    @Bean
    public LoadingCache<OidcRegisteredService, Optional<RsaJsonWebKey>> oidcServiceJsonWebKeystoreCache() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        LoadingCache cache = Caffeine.newBuilder().maximumSize(1L).expireAfterWrite((long)oidc.getJwksCacheInMinutes(), TimeUnit.MINUTES).build(this.oidcServiceJsonWebKeystoreCacheLoader());
        return cache;
    }

    @Bean
    public LoadingCache<String, Optional<RsaJsonWebKey>> oidcDefaultJsonWebKeystoreCache() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        LoadingCache cache = Caffeine.newBuilder().maximumSize(1L).expireAfterWrite((long)oidc.getJwksCacheInMinutes(), TimeUnit.MINUTES).build((CacheLoader)this.oidcDefaultJsonWebKeystoreCacheLoader());
        return cache;
    }

    @Bean
    public OidcDefaultJsonWebKeystoreCacheLoader oidcDefaultJsonWebKeystoreCacheLoader() {
        return new OidcDefaultJsonWebKeystoreCacheLoader(this.casProperties.getAuthn().getOidc().getJwksFile());
    }

    @Bean
    public CacheLoader<OidcRegisteredService, Optional<RsaJsonWebKey>> oidcServiceJsonWebKeystoreCacheLoader() {
        return new OidcServiceJsonWebKeystoreCacheLoader(this.resourceLoader);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServerDiscoverySettingsFactory"})
    public FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory() {
        return new OidcServerDiscoverySettingsFactory(this.casProperties);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcJsonWebKeystoreGeneratorService"})
    public OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService() {
        OidcJsonWebKeystoreGeneratorService s = new OidcJsonWebKeystoreGeneratorService(this.casProperties.getAuthn().getOidc());
        s.generate();
        return s;
    }

    @Bean
    public HandlerInterceptorAdapter oauthInterceptor() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        OidcConstants.DynamicClientRegistrationMode mode = OidcConstants.DynamicClientRegistrationMode.valueOf((String)((String)StringUtils.defaultIfBlank((CharSequence)oidc.getDynamicClientRegistrationMode(), (CharSequence)OidcConstants.DynamicClientRegistrationMode.PROTECTED.name())));
        return new OidcHandlerInterceptorAdapter((HandlerInterceptorAdapter)this.requiresAuthenticationAccessTokenInterceptor, this.requiresAuthenticationAuthorizeInterceptor(), this.requiresAuthenticationDynamicRegistrationInterceptor(), mode, this.accessTokenGrantRequestExtractors);
    }

    @RefreshScope
    @Bean
    public Collection<BaseOidcScopeAttributeReleasePolicy> userDefinedScopeBasedAttributeReleasePolicies() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return oidc.getUserDefinedScopes().entrySet().stream().map(k -> new OidcCustomScopeAttributeReleasePolicy((String)k.getKey(), CollectionUtils.wrapList((Object[])((String)k.getValue()).split(",")))).collect(Collectors.toSet());
    }

    @Bean
    public OidcRegisteredServicePreProcessorEventListener oidcRegisteredServicePreProcessorEventListener() {
        return new OidcRegisteredServicePreProcessorEventListener(this.profileScopeToAttributesFilter());
    }

    @Bean
    public OAuth20AuthorizationResponseBuilder oidcImplicitIdTokenCallbackUrlBuilder() {
        return new OidcImplicitIdTokenAuthorizationResponseBuilder(this.oidcIdTokenGenerator(), this.oauthTokenGenerator, this.accessTokenExpirationPolicy, this.grantingTicketExpirationPolicy);
    }

    public void configureWebflowExecutionPlan(CasWebflowExecutionPlan plan) {
        plan.registerWebflowConfigurer(this.oidcWebflowConfigurer());
    }
}

