/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.CookieUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class OAuth20AuthorizeEndpointController
extends BaseOAuth20Controller {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizeEndpointController.class);
    protected final OAuthCodeFactory oAuthCodeFactory;
    protected final ConsentApprovalViewResolver consentApprovalViewResolver;
    protected final OAuth20CasAuthenticationBuilder authenticationBuilder;
    protected final Set<OAuth20AuthorizationResponseBuilder> oauthAuthorizationResponseBuilders;
    protected final Set<OAuth20AuthorizationRequestValidator> oauthRequestValidators;
    protected final AuditableExecution registeredServiceAccessStrategyEnforcer;

    public OAuth20AuthorizeEndpointController(ServicesManager servicesManager, TicketRegistry ticketRegistry, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuthCodeFactory oAuthCodeFactory, ConsentApprovalViewResolver consentApprovalViewResolver, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, OAuth20CasAuthenticationBuilder authenticationBuilder, Set<OAuth20AuthorizationResponseBuilder> oauthAuthorizationResponseBuilders, Set<OAuth20AuthorizationRequestValidator> oauthRequestValidators, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        super(servicesManager, ticketRegistry, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, ticketGrantingTicketCookieGenerator);
        this.oAuthCodeFactory = oAuthCodeFactory;
        this.consentApprovalViewResolver = consentApprovalViewResolver;
        this.authenticationBuilder = authenticationBuilder;
        this.oauthAuthorizationResponseBuilders = oauthAuthorizationResponseBuilders;
        this.oauthRequestValidators = oauthRequestValidators;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }

    @GetMapping(path={"/oauth2.0/authorize"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        J2EContext context = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = Pac4jUtils.getPac4jProfileManager((HttpServletRequest)request, (HttpServletResponse)response);
        if (!this.verifyAuthorizeRequest(context) || !OAuth20AuthorizeEndpointController.isRequestAuthenticated(manager, context)) {
            LOGGER.error("Authorize request verification failed. Either the authorization request is missing required parameters, or the request is not authenticated and contains no authenticated profile/principal.");
            return OAuth20Utils.produceUnauthorizedErrorView();
        }
        String clientId = context.getRequestParameter("client_id");
        OAuthRegisteredService registeredService = this.getRegisteredServiceByClientId(clientId);
        try {
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((String)clientId, (RegisteredService)registeredService);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return OAuth20Utils.produceUnauthorizedErrorView();
        }
        ModelAndView mv = this.consentApprovalViewResolver.resolve(context, registeredService);
        if (!mv.isEmpty() && mv.hasView()) {
            return mv;
        }
        return this.redirectToCallbackRedirectUrl(manager, registeredService, context, clientId);
    }

    @PostMapping(path={"/oauth2.0/authorize"})
    public ModelAndView handleRequestPost(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.handleRequest(request, response);
    }

    protected OAuthRegisteredService getRegisteredServiceByClientId(String clientId) {
        return OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, clientId);
    }

    private static boolean isRequestAuthenticated(ProfileManager manager, J2EContext context) {
        Optional opt = manager.get(true);
        return opt.isPresent();
    }

    protected ModelAndView redirectToCallbackRedirectUrl(ProfileManager manager, OAuthRegisteredService registeredService, J2EContext context, String clientId) {
        Optional profile = manager.get(true);
        if (profile == null || !profile.isPresent()) {
            LOGGER.error("Unexpected null profile from profile manager. Request is not fully authenticated.");
            return OAuth20Utils.produceUnauthorizedErrorView();
        }
        Service service = this.authenticationBuilder.buildService(registeredService, context, false);
        LOGGER.debug("Created service [{}] based on registered service [{}]", (Object)service, (Object)registeredService);
        Authentication authentication = this.authenticationBuilder.build((UserProfile)profile.get(), registeredService, context, service);
        LOGGER.debug("Created OAuth authentication [{}] for service [{}]", (Object)service, (Object)authentication);
        try {
            AuditableContext audit = AuditableContext.builder().service(service).authentication(authentication).registeredService((RegisteredService)registeredService).retrievePrincipalAttributesFromReleasePolicy(Boolean.TRUE).build();
            AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
            accessResult.throwExceptionIfNeeded();
        }
        catch (PrincipalException | UnauthorizedServiceException e) {
            LOGGER.error(e.getMessage(), e);
            return OAuth20Utils.produceUnauthorizedErrorView();
        }
        View view = this.buildAuthorizationForRequest(registeredService, context, clientId, service, authentication);
        if (view != null) {
            return OAuth20Utils.redirectTo(view);
        }
        LOGGER.debug("No explicit view was defined as part of the authorization response");
        return null;
    }

    protected View buildAuthorizationForRequest(OAuthRegisteredService registeredService, J2EContext context, String clientId, Service service, Authentication authentication) {
        OAuth20AuthorizationResponseBuilder builder = this.oauthAuthorizationResponseBuilders.stream().filter(b -> b.supports(context)).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not build the callback url. Response type likely not supported"));
        TicketGrantingTicket ticketGrantingTicket = CookieUtils.getTicketGrantingTicketFromRequest((CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator, (TicketRegistry)this.ticketRegistry, (HttpServletRequest)context.getRequest());
        String grantType = ((String)StringUtils.defaultIfEmpty((CharSequence)context.getRequestParameter("grant_type"), (CharSequence)OAuth20GrantTypes.AUTHORIZATION_CODE.getType())).toUpperCase();
        Set<String> scopes = OAuth20Utils.parseRequestScopes(context);
        AccessTokenRequestDataHolder holder = new AccessTokenRequestDataHolder(service, authentication, registeredService, ticketGrantingTicket, OAuth20GrantTypes.valueOf(grantType), scopes);
        LOGGER.debug("Building authorization response for grant type [{}] with scopes [{}] for client id [{}]", new Object[]{grantType, scopes, clientId});
        return builder.build(context, clientId, holder);
    }

    private boolean verifyAuthorizeRequest(J2EContext context) {
        OAuth20AuthorizationRequestValidator validator = this.oauthRequestValidators.stream().filter(b -> b.supports(context)).findFirst().orElse(null);
        if (validator == null) {
            LOGGER.warn("Ignoring malformed request [{}] no OAuth20 validator could declare support for its syntax", (Object)context.getFullRequestURL());
            return false;
        }
        return validator.validate(context);
    }
}

