/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.Collection;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class OAuth20HandlerInterceptorAdapter
extends HandlerInterceptorAdapter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20HandlerInterceptorAdapter.class);
    protected final HandlerInterceptorAdapter requiresAuthenticationAccessTokenInterceptor;
    protected final HandlerInterceptorAdapter requiresAuthenticationAuthorizeInterceptor;
    private final Collection<BaseAccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.isAccessTokenRequestRequest(request, response)) {
            return this.requiresAuthenticationAccessTokenInterceptor.preHandle(request, response, handler);
        }
        if (this.isAuthorizationRequest(request, response)) {
            return this.requiresAuthenticationAuthorizeInterceptor.preHandle(request, response, handler);
        }
        return true;
    }

    protected boolean isAccessTokenRequestRequest(HttpServletRequest request, HttpServletResponse response) {
        BaseAccessTokenGrantRequestExtractor extractor;
        boolean value;
        String requestPath = request.getRequestURI();
        boolean bl = value = this.doesUriMatchPattern(requestPath, "accessToken") || this.doesUriMatchPattern(requestPath, "token");
        if (!value && (extractor = (BaseAccessTokenGrantRequestExtractor)this.accessTokenGrantRequestExtractors.stream().filter(ext -> ext.supports(request)).findFirst().orElse(null)) != null) {
            return extractor.getGrantType() == OAuth20GrantTypes.CLIENT_CREDENTIALS || extractor.getGrantType() == OAuth20GrantTypes.PASSWORD;
        }
        return value;
    }

    protected boolean isAuthorizationRequest(HttpServletRequest request, HttpServletResponse response) {
        String requestPath = request.getRequestURI();
        return this.doesUriMatchPattern(requestPath, "authorize");
    }

    protected boolean doesUriMatchPattern(String requestPath, String patternUrl) {
        Pattern pattern = Pattern.compile('/' + patternUrl + "(/)*$");
        return pattern.matcher(requestPath).find();
    }

    @Generated
    public OAuth20HandlerInterceptorAdapter(HandlerInterceptorAdapter requiresAuthenticationAccessTokenInterceptor, HandlerInterceptorAdapter requiresAuthenticationAuthorizeInterceptor, Collection<BaseAccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors) {
        this.requiresAuthenticationAccessTokenInterceptor = requiresAuthenticationAccessTokenInterceptor;
        this.requiresAuthenticationAuthorizeInterceptor = requiresAuthenticationAuthorizeInterceptor;
        this.accessTokenGrantRequestExtractors = accessTokenGrantRequestExtractors;
    }
}

