/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.authorization;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.util.HttpRequestUtils;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20RefreshTokenGrantTypeAuthorizationRequestValidator
implements OAuth20AuthorizationRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20RefreshTokenGrantTypeAuthorizationRequestValidator.class);
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;

    @Override
    public boolean validate(J2EContext context) {
        HttpServletRequest request = context.getRequest();
        if (!HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"grant_type")) {
            LOGGER.warn("Grant type must be specified");
            return false;
        }
        String grantType = context.getRequestParameter("grant_type");
        if (!HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"client_id")) {
            LOGGER.warn("Client id not specified for grant type [{}]", (Object)grantType);
            return false;
        }
        if (!HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"secret")) {
            LOGGER.warn("Client secret is not specified for grant type [{}]", (Object)grantType);
            return false;
        }
        if (!HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"refresh_token")) {
            LOGGER.warn("Refresh token is not specified for grant type [{}]", (Object)grantType);
            return false;
        }
        String clientId = context.getRequestParameter("client_id");
        OAuthRegisteredService registeredService = this.getRegisteredServiceByClientId(clientId);
        if (registeredService == null) {
            throw new UnauthorizedServiceException("screen.service.error.message", "Service unauthorized");
        }
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceServiceFactory.createService(registeredService.getServiceId());
        AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
        if (accessResult.isExecutionFailure()) {
            LOGGER.warn("Registered service [{}] is not found or is not authorized for access.", (Object)registeredService);
            return false;
        }
        return OAuth20Utils.isAuthorizedGrantTypeForService(context, registeredService);
    }

    protected OAuthRegisteredService getRegisteredServiceByClientId(String clientId) {
        return OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, clientId);
    }

    @Override
    public boolean supports(J2EContext context) {
        String grantType = context.getRequestParameter("grant_type");
        return OAuth20Utils.isGrantType(grantType, OAuth20GrantTypes.REFRESH_TOKEN);
    }

    @Generated
    public OAuth20RefreshTokenGrantTypeAuthorizationRequestValidator(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        this.servicesManager = servicesManager;
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }
}

