/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public final class OAuth20Utils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20Utils.class);
    private static final ObjectWriter WRITER = new ObjectMapper().findAndRegisterModules().writer().withDefaultPrettyPrinter();

    public static ModelAndView writeTextError(HttpServletResponse response, String error) {
        return OAuth20Utils.writeText(response, "error=" + error, 400);
    }

    public static ModelAndView writeText(HttpServletResponse response, String text, int status) {
        try (PrintWriter printWriter = response.getWriter();){
            response.setStatus(status);
            printWriter.print(text);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write to response", (Throwable)e);
        }
        return null;
    }

    public static ModelAndView redirectTo(View view) {
        return new ModelAndView(view);
    }

    public static OAuthRegisteredService getRegisteredOAuthServiceByClientId(ServicesManager servicesManager, String clientId) {
        return OAuth20Utils.getRegisteredOAuthServiceByPredicate(servicesManager, s -> s.getClientId().equals(clientId));
    }

    public static OAuthRegisteredService getRegisteredOAuthServiceByRedirectUri(ServicesManager servicesManager, String redirectUri) {
        return OAuth20Utils.getRegisteredOAuthServiceByPredicate(servicesManager, s -> s.matches(redirectUri));
    }

    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    private static OAuthRegisteredService getRegisteredOAuthServiceByPredicate(ServicesManager servicesManager, Predicate<OAuthRegisteredService> predicate) {
        Collection services = servicesManager.getAllServices();
        return services.stream().filter(OAuthRegisteredService.class::isInstance).map(OAuthRegisteredService.class::cast).filter(predicate).findFirst().orElse(null);
    }

    public static Map<String, Object> getRequestParameters(Collection<String> attributes, HttpServletRequest context) {
        return attributes.stream().filter(a -> StringUtils.isNotBlank((CharSequence)context.getParameter(a))).map(m -> {
            String[] values = context.getParameterValues(m);
            LinkedHashSet valuesSet = new LinkedHashSet();
            if (values != null && values.length > 0) {
                Arrays.stream(values).forEach(v -> valuesSet.addAll(Arrays.stream(v.split(" ")).collect(Collectors.toSet())));
            }
            return Pair.of((Object)m, valuesSet);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public static Collection<String> getRequestedScopes(J2EContext context) {
        return OAuth20Utils.getRequestedScopes(context.getRequest());
    }

    public static Collection<String> getRequestedScopes(HttpServletRequest context) {
        Map<String, Object> map = OAuth20Utils.getRequestParameters(CollectionUtils.wrap((Object)"scope"), context);
        if (map == null || map.isEmpty()) {
            return new ArrayList<String>(0);
        }
        return (Collection)map.get("scope");
    }

    public static ModelAndView produceUnauthorizedErrorView() {
        return OAuth20Utils.produceErrorView((Exception)new UnauthorizedServiceException("screen.service.error.message", ""));
    }

    public static ModelAndView produceErrorView(Exception e) {
        HashMap<String, Exception> model = new HashMap<String, Exception>();
        model.put("rootCauseException", e);
        return new ModelAndView("casServiceErrorView", model);
    }

    public static String casOAuthCallbackUrl(String serverPrefixUrl) {
        return serverPrefixUrl.concat("/oauth2.0/callbackAuthorize");
    }

    public static String jsonify(Map map) {
        return WRITER.writeValueAsString((Object)map);
    }

    public static OAuth20ResponseTypes getResponseType(J2EContext context) {
        String responseType = context.getRequestParameter("response_type");
        OAuth20ResponseTypes type = Arrays.stream(OAuth20ResponseTypes.values()).filter(t -> t.getType().equalsIgnoreCase(responseType)).findFirst().orElse(OAuth20ResponseTypes.CODE);
        LOGGER.debug("OAuth response type is [{}]", (Object)type);
        return type;
    }

    public static boolean isGrantType(String type, OAuth20GrantTypes expectedType) {
        return expectedType.name().equalsIgnoreCase(type);
    }

    public static boolean isResponseType(String type, OAuth20ResponseTypes expectedType) {
        return expectedType.getType().equalsIgnoreCase(type);
    }

    public static boolean isAuthorizedResponseTypeForService(J2EContext context, OAuthRegisteredService registeredService) {
        String responseType = context.getRequestParameter("response_type");
        if (registeredService.getSupportedResponseTypes() != null && !registeredService.getSupportedResponseTypes().isEmpty()) {
            LOGGER.debug("Checking response type [{}] against supported response types [{}]", (Object)responseType, (Object)registeredService.getSupportedResponseTypes());
            return registeredService.getSupportedResponseTypes().stream().anyMatch(s -> s.equalsIgnoreCase(responseType));
        }
        LOGGER.warn("Registered service [{}] does not define any authorized/supported response types. It is STRONGLY recommended that you authorize and assign response types to the service definition. While just a warning for now, this behavior will be enforced by CAS in future versions.", (Object)registeredService.getName());
        return true;
    }

    public static boolean isAuthorizedGrantTypeForService(J2EContext context, OAuthRegisteredService registeredService) {
        String grantType = context.getRequestParameter("grant_type");
        if (registeredService.getSupportedGrantTypes() != null && !registeredService.getSupportedGrantTypes().isEmpty()) {
            LOGGER.debug("Checking grant type [{}] against supported grant types [{}]", (Object)grantType, (Object)registeredService.getSupportedGrantTypes());
            return registeredService.getSupportedGrantTypes().stream().anyMatch(s -> s.equalsIgnoreCase(grantType));
        }
        LOGGER.warn("Registered service [{}] does not define any authorized/supported grant types. It is STRONGLY recommended that you authorize and assign grant types to the service definition. While just a warning for now, this behavior will be enforced by CAS in future versions.", (Object)registeredService.getName());
        return true;
    }

    public static Set<String> parseRequestScopes(J2EContext context) {
        return OAuth20Utils.parseRequestScopes(context.getRequest());
    }

    public static Set<String> parseRequestScopes(HttpServletRequest context) {
        String parameterValues = context.getParameter("scope");
        if (StringUtils.isBlank((CharSequence)parameterValues)) {
            return new HashSet<String>(0);
        }
        return CollectionUtils.wrapSet((Object[])parameterValues.split(" "));
    }

    public static String getServiceRequestHeaderIfAny(HttpServletRequest context) {
        if (context == null) {
            return null;
        }
        String id = context.getHeader("service");
        if (StringUtils.isBlank((CharSequence)id)) {
            id = context.getHeader("X-".concat("service"));
        }
        return id;
    }

    public static boolean checkCallbackValid(@NonNull RegisteredService registeredService, String redirectUri) {
        if (registeredService == null) {
            throw new NullPointerException("registeredService is marked @NonNull but is null");
        }
        String registeredServiceId = registeredService.getServiceId();
        LOGGER.debug("Found: [{}] vs redirectUri: [{}]", (Object)registeredService, (Object)redirectUri);
        if (!redirectUri.matches(registeredServiceId)) {
            LOGGER.error("Unsupported [{}]: [{}] does not match what is defined for registered service: [{}]. Service is considered unauthorized. Verify the service definition in the registry is correct and does in fact match the client [{}]", new Object[]{"redirect_uri", redirectUri, registeredServiceId, redirectUri});
            return false;
        }
        return true;
    }

    public static boolean checkClientSecret(OAuthRegisteredService registeredService, String clientSecret) {
        LOGGER.debug("Found: [{}] in secret check", (Object)registeredService);
        if (StringUtils.isBlank((CharSequence)registeredService.getClientSecret())) {
            LOGGER.debug("The client secret is not defined for the registered service [{}]", (Object)registeredService.getName());
            return true;
        }
        if (!StringUtils.equals((CharSequence)registeredService.getClientSecret(), (CharSequence)clientSecret)) {
            LOGGER.error("Wrong client secret for service: [{}]", (Object)registeredService);
            return false;
        }
        return true;
    }

    public static boolean checkResponseTypes(String type, OAuth20ResponseTypes ... expectedTypes) {
        LOGGER.debug("Response type: [{}]", (Object)type);
        boolean checked = Stream.of(expectedTypes).anyMatch(t -> OAuth20Utils.isResponseType(type, t));
        if (!checked) {
            LOGGER.error("Unsupported response type: [{}]", (Object)type);
        }
        return checked;
    }

    @Generated
    private OAuth20Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

