/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.views;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.hjson.JsonValue;
import org.hjson.Stringify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20DefaultUserProfileViewRenderer
implements OAuth20UserProfileViewRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20DefaultUserProfileViewRenderer.class);
    private final OAuthProperties oauthProperties;

    public OAuth20DefaultUserProfileViewRenderer(OAuthProperties oauthProperties) {
        this.oauthProperties = oauthProperties;
    }

    @Override
    public String render(Map<String, Object> model, AccessToken accessToken) {
        String value;
        switch (this.oauthProperties.getUserProfileViewType()) {
            case FLAT: {
                LinkedHashMap flattened = new LinkedHashMap();
                if (model.containsKey("attributes")) {
                    Map attributes = (Map)Map.class.cast(model.get("attributes"));
                    flattened.putAll(attributes);
                }
                model.keySet().stream().filter(k -> !k.equalsIgnoreCase("attributes")).forEach(k -> flattened.put(k, model.get(k)));
                value = OAuth20Utils.jsonify(flattened);
                break;
            }
            default: {
                value = OAuth20Utils.jsonify(model);
            }
        }
        LOGGER.debug("Final user profile is [{}]", (Object)JsonValue.readHjson((String)value).toString(Stringify.FORMATTED));
        return value;
    }
}

